/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Comparator;
import java.util.Map;

public class EntryValueComparator
implements Comparator {
    private boolean ascending;
    private boolean useMagnitude;
    private Map m;

    public EntryValueComparator() {
        this(null, true);
    }

    public EntryValueComparator(boolean ascending) {
        this(null, ascending);
    }

    public EntryValueComparator(Map m) {
        this(m, true);
    }

    public EntryValueComparator(Map m, boolean ascending) {
        this(m, ascending, false);
    }

    public EntryValueComparator(Map m, boolean ascending, boolean useMagnitude) {
        this.m = m;
        this.ascending = ascending;
        this.useMagnitude = useMagnitude;
    }

    public int compare(Object o1, Object o2) {
        Object v2;
        Object v1;
        if (o1 instanceof Map.Entry) {
            v1 = ((Map.Entry)o1).getValue();
        } else if (this.m != null) {
            v1 = this.m.get(o1);
            if (v1 == null) {
                throw new RuntimeException("Key not found in map.");
            }
        } else {
            v1 = o1;
        }
        if (o2 instanceof Map.Entry) {
            v2 = ((Map.Entry)o2).getValue();
        } else if (this.m != null) {
            v2 = this.m.get(o2);
            if (v2 == null) {
                throw new RuntimeException("Key not found in map.");
            }
        } else {
            v2 = o2;
        }
        if (this.useMagnitude) {
            v1 = new Double(Math.abs(((Number)v1).doubleValue()));
            v2 = new Double(Math.abs(((Number)v2).doubleValue()));
        }
        int result = this.ascending ? ((Comparable)v1).compareTo(v2) : ((Comparable)v2).compareTo(v1);
        return result;
    }
}

