/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZLanguagePack;
import java.util.HashMap;
import java.util.regex.Pattern;

public class TueBaDZHeadFinder
extends AbstractCollinsHeadFinder {
    String left;
    String right;
    private boolean coordSwitch = false;
    private final Pattern headMarkedPattern;

    public TueBaDZHeadFinder() {
        super(new TueBaDZLanguagePack());
        String excluded = String.valueOf(this.tlp.labelAnnotationIntroducingCharacters());
        if (excluded.indexOf("-") >= 0) {
            excluded = "-" + excluded.replaceAll("-", "");
        }
        this.headMarkedPattern = Pattern.compile("^[^" + excluded + "]*:HD");
        this.nonTerminalInfo = new HashMap();
        this.left = this.coordSwitch ? "right" : "left";
        this.right = this.coordSwitch ? "left" : "right";
        this.nonTerminalInfo.put("ROOT", new String[][]{{this.left, "SIMPX"}, {this.left, "NX"}, {this.left, "P"}, {this.left, "PX", "ADVX"}, {this.left, "EN", "EN_ADD"}, {this.left}});
        this.nonTerminalInfo.put("PX", new String[][]{{this.left, "APPR", "APPRART", "PX"}});
        this.nonTerminalInfo.put("NX", new String[][]{{this.right, "NX"}, {this.right, "NE", "NN"}, {this.right, "EN", "EN_ADD", "FX"}, {this.right, "ADJX", "PIS", "ADVX"}, {this.right, "CARD", "TRUNC"}, {this.right}});
        this.nonTerminalInfo.put("FX", new String[][]{{this.right, "FM", "FX"}});
        this.nonTerminalInfo.put("ADJX", new String[][]{{this.right, "ADJX", "ADJA", "ADJD"}, {this.right}});
        this.nonTerminalInfo.put("ADVX", new String[][]{{this.right, "ADVX"}});
        this.nonTerminalInfo.put("DP", new String[][]{{this.left}});
        this.nonTerminalInfo.put("VXFIN", new String[][]{{this.left, "VXFIN"}, {this.right, "VVFIN"}});
        this.nonTerminalInfo.put("VXINF", new String[][]{{this.right, "VXINF"}, {this.right, "VVPP", "VVINF"}});
        this.nonTerminalInfo.put("LV", new String[][]{{this.right}});
        this.nonTerminalInfo.put("C", new String[][]{{this.right, "KOUS"}});
        this.nonTerminalInfo.put("FKOORD", new String[][]{{this.left, "LK", "C"}, {this.right, "FKONJ", "MF", "VC"}});
        this.nonTerminalInfo.put("KOORD", new String[][]{{this.left}});
        this.nonTerminalInfo.put("LK", new String[][]{{this.left}});
        this.nonTerminalInfo.put("MF", new String[][]{{this.left}});
        this.nonTerminalInfo.put("MFE", new String[][]{{this.left}});
        this.nonTerminalInfo.put("NF", new String[][]{{this.left}});
        this.nonTerminalInfo.put("PARORD", new String[][]{{this.left}});
        this.nonTerminalInfo.put("VC", new String[][]{{this.left, "VXINF"}});
        this.nonTerminalInfo.put("VF", new String[][]{{this.left, "NX", "ADJX", "PX", "ADVX", "EN", "SIMPX"}});
        this.nonTerminalInfo.put("FKONJ", new String[][]{{this.left, "LK"}, {this.right, "VC"}, {this.left, "MF", "NF", "VF"}});
        this.nonTerminalInfo.put("DM", new String[][]{{this.left, "PTKANT"}, {this.left, "ITJ"}, {this.left, "KON", "FM"}, {this.left}});
        this.nonTerminalInfo.put("P", new String[][]{{this.left, "SIMPX"}, {this.left}});
        this.nonTerminalInfo.put("R", new String[][]{{this.left, "C"}, {this.left, "R"}, {this.right, "VC"}});
        this.nonTerminalInfo.put("SIMPX", new String[][]{{this.left, "LK"}, {this.right, "VC"}, {this.left, "SIMPX"}, {this.left, "C"}, {this.right, "FKOORD"}, {this.right, "MF"}, {this.right}});
        this.nonTerminalInfo.put("EN", new String[][]{{this.left, "NX"}});
        this.nonTerminalInfo.put("EN_ADD", new String[][]{{this.left, "NX"}});
    }

    protected Tree findMarkedHead(Tree t) {
        Tree[] kids = t.children();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            if (!this.headMarkedPattern.matcher(kids[i].label().value()).find()) continue;
            return kids[i];
        }
        return null;
    }
}

