/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.AbstractMapLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.trees.LabeledConstituent;

public class UnnamedDependency
implements Dependency {
    private Label regent;
    private Label dependent;
    private static final long serialVersionUID = 5L;

    public int hashCode() {
        return this.regent.hashCode() ^ this.dependent.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnnamedDependency) {
            UnnamedDependency d = (UnnamedDependency)o;
            return this.governor().equals(d.governor()) && this.dependent().equals(d.dependent());
        }
        return false;
    }

    public boolean equalIgnoringName(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Dependency) {
            Dependency d = (Dependency)o;
            return this.governor().equals(d.governor()) && this.dependent().equals(d.dependent());
        }
        return false;
    }

    public String toString() {
        return this.regent + " --> " + this.dependent;
    }

    private static String getIndexStrOrEmpty(Label lab) {
        AbstractMapLabel aml;
        int idx;
        String ans = "";
        if (lab instanceof AbstractMapLabel && (idx = (aml = (AbstractMapLabel)lab).index()) >= 0) {
            ans = " idx=\"" + idx + "\"";
        }
        return ans;
    }

    public String toString(String format) {
        if ("xml".equals(format)) {
            String govIdxStr = UnnamedDependency.getIndexStrOrEmpty(this.governor());
            String depIdxStr = UnnamedDependency.getIndexStrOrEmpty(this.dependent());
            return "  <dep>\n    <governor" + govIdxStr + ">" + this.governor().value() + "</governor>\n    <dependent" + depIdxStr + ">" + this.dependent().value() + "</dependent>\n  </dep>";
        }
        if ("predicate".equals(format)) {
            return "dep(" + this.governor() + "," + this.dependent() + ")";
        }
        return this.toString();
    }

    public UnnamedDependency(String regent, String dependent) {
        this(new StringLabel(regent), new StringLabel(dependent));
    }

    public UnnamedDependency(String regent, int regentIndex, String dependent, int dependentIndex) {
        this(regent, regentIndex, regentIndex + 1, dependent, dependentIndex, dependentIndex + 1);
    }

    public UnnamedDependency(String regent, int regentStartIndex, int regentEndIndex, String dependent, int depStartIndex, int depEndIndex) {
        this(new LabeledConstituent(regentStartIndex, regentEndIndex, regent), new LabeledConstituent(depStartIndex, depEndIndex, dependent));
    }

    public UnnamedDependency(Label regent, Label dependent) {
        if (regent == null || dependent == null) {
            throw new IllegalArgumentException("governor or dependent cannot be null");
        }
        this.regent = regent;
        this.dependent = dependent;
    }

    public Label governor() {
        return this.regent;
    }

    public Label dependent() {
        return this.dependent;
    }

    public Object name() {
        return null;
    }

    public DependencyFactory dependencyFactory() {
        return DependencyFactoryHolder.df;
    }

    public static DependencyFactory factory() {
        return DependencyFactoryHolder.df;
    }

    private static class UnnamedDependencyFactory
    implements DependencyFactory {
        public Dependency newDependency(Label regent, Label dependent) {
            return this.newDependency(regent, dependent, null);
        }

        public Dependency newDependency(Label regent, Label dependent, Object name) {
            return new UnnamedDependency(regent, dependent);
        }
    }

    private static class DependencyFactoryHolder {
        private static final DependencyFactory df = new UnnamedDependencyFactory();

        private DependencyFactoryHolder() {
        }
    }
}

