/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishGrammaticalStructure
extends GrammaticalStructure {
    public static final String CONJ_MARKER = "conj_";
    private static final boolean DEBUG = false;
    private static String[][] MULTIWORD_PREPS = new String[][]{{"according", "to"}, {"across", "from"}, {"ahead", "of"}, {"along", "with"}, {"due", "to"}, {"alongside", "of"}, {"apart", "from"}, {"as", "of"}, {"as", "to"}, {"away", "from"}, {"based", "on"}, {"because", "of"}, {"close", "by"}, {"close", "to"}, {"due", "to"}, {"compared", "to"}, {"compared", "with"}, {"depending", "on"}, {"followed", "by"}, {"inside", "of"}, {"instead", "of"}, {"next", "to"}, {"near", "to"}, {"out", "of"}, {"outside", "of"}, {"prior", "to"}, {"together", "with"}};

    public EnglishGrammaticalStructure(Tree t) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        super(new CoordinationTransformer().transformTree(t), EnglishGrammaticalRelations.values(), EnglishGrammaticalStructure.getSemanticHeadFinder(t), puncFilter);
    }

    protected static SemanticHeadFinder getSemanticHeadFinder(Tree t) {
        SemanticHeadFinder shf = EnglishGrammaticalStructure.isExistential(t) || EnglishGrammaticalStructure.isWHQ(t) ? new SemanticHeadFinder(false) : new SemanticHeadFinder(true);
        return shf;
    }

    private static boolean isExistential(Tree t) {
        boolean toReturn = false;
        List<Label> tags = t.preTerminalYield();
        for (Label tag : tags) {
            if (!tag.value().equals("EX")) continue;
            toReturn = true;
        }
        return toReturn;
    }

    private static boolean isWHQ(Tree t) {
        if (t == null) {
            return false;
        }
        Tree firstChild = t.firstChild();
        if (firstChild == null) {
            return false;
        }
        boolean seenWH = false;
        boolean seenSQ = false;
        if ("SBARQ".equals(firstChild.value())) {
            Tree[] kids;
            for (Tree kid : kids = firstChild.children()) {
                if (kid.value() == null) continue;
                if (kid.value().startsWith("WH")) {
                    seenWH = true;
                    continue;
                }
                if (!kid.value().equals("SQ")) continue;
                seenSQ = true;
            }
        }
        return seenWH && seenSQ;
    }

    public TreeGraphNode getSubject(TreeGraphNode t) {
        TreeGraphNode subj = this.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        if (subj == null) {
            return this.getNodeInRelation(t, EnglishGrammaticalRelations.CLAUSAL_SUBJECT);
        }
        return subj;
    }

    @Override
    protected void correctDependencies(Collection<TypedDependency> list) {
        this.correctSubjPassAndPoss(list);
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            System.err.println(title);
        }
        System.err.println(lis);
    }

    @Override
    protected void collapseDependencies(Collection<TypedDependency> list, boolean CCprocess) {
        this.correctDependencies(list);
        this.collapsePrepAndPoss(list);
        this.collapseConj(list);
        if (CCprocess) {
            this.treatCC(list);
        }
        this.collapseMultiwordPreps(list);
        this.collapseReferent(list);
        Collections.sort((List)list);
    }

    protected GrammaticalRelation conjValue(Object conj) {
        String newConj = conj.toString().toLowerCase();
        if (conj.toString().equals("not") || conj.toString().equals("instead") || conj.toString().equals("rather")) {
            newConj = "negcc";
        } else if (conj.toString().equals("to") || conj.toString().equals("also") || conj.toString().equals("well")) {
            newConj = "and";
        }
        return EnglishGrammaticalRelations.getConj(newConj);
    }

    private void treatCC(Collection<TypedDependency> list) {
        HashMap map = new HashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.dep())) {
                map.put(typedDep.dep(), new HashSet());
            }
            ((Set)map.get(typedDep.dep())).add(typedDep);
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>(list);
        for (TypedDependency td : list) {
            if (!EnglishGrammaticalRelations.getConjs().contains(td.reln())) continue;
            TreeGraphNode gov = td.gov();
            TreeGraphNode dep = td.dep();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations == null) continue;
            for (TypedDependency td1 : gov_relations) {
                TreeGraphNode newGov = td1.gov();
                GrammaticalRelation newRel = td1.reln();
                newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
            }
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private void collapseConj(Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode gov = td.gov();
            GrammaticalRelation conj = this.conjValue(td.dep().value());
            for (TypedDependency td1 : list) {
                if (td1.reln() == EnglishGrammaticalRelations.CONJUNCT && td1.gov() == gov) {
                    td1.setReln(conj);
                    continue;
                }
                if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
                conj = this.conjValue(td1.dep().value());
            }
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.COORDINATION) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private void collapseReferent(Collection<TypedDependency> list) {
        ArrayList<Pair<TreeGraphNode, TreeGraphNode>> refs = new ArrayList<Pair<TreeGraphNode, TreeGraphNode>>();
        for (TypedDependency typedDependency : list) {
            if (typedDependency.reln() != EnglishGrammaticalRelations.REFERENT) continue;
            Pair<TreeGraphNode, TreeGraphNode> ref = new Pair<TreeGraphNode, TreeGraphNode>(typedDependency.dep(), typedDependency.gov());
            refs.add(ref);
        }
        for (Pair pair : refs) {
            TreeGraphNode dep = (TreeGraphNode)pair.first();
            TreeGraphNode ant = (TreeGraphNode)pair.second();
            for (TypedDependency td : list) {
                if (td.dep() != dep || td.reln() == EnglishGrammaticalRelations.RELATIVE) continue;
                td.setDep(ant);
            }
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.REFERENT) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private void correctSubjPassAndPoss(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> list_auxpass = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
            list_auxpass.add(td.gov());
        }
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
            }
            String tag = td.dep().parent().value();
            if (td.reln() != GrammaticalRelation.DEPENDENT || !tag.equals("PRP$") && !tag.equals("WP$")) continue;
            td.setReln(EnglishGrammaticalRelations.POSSESSION_MODIFIER);
        }
    }

    private void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new HashSet());
            }
            ((Set)map.get(typedDep.gov())).add(typedDep);
        }
        for (TypedDependency td1 : list) {
            TypedDependency tdNew;
            Set aux_pass_poss;
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            TypedDependency prepDep = null;
            TypedDependency ccDep = null;
            TypedDependency conjDep = null;
            TypedDependency prep2Dep = null;
            HashSet<TypedDependency> otherDtrs = new HashSet<TypedDependency>();
            for (TypedDependency td2 : possibles) {
                String td2DepPOS;
                TreeGraphNode td2Dep;
                if (td2.reln() == EnglishGrammaticalRelations.COORDINATION) {
                    ccDep = td2;
                    continue;
                }
                if (td2.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                    Set possibles2;
                    conjDep = td2;
                    td2Dep = td2.dep();
                    td2DepPOS = td2Dep.parent().value();
                    if (!td2DepPOS.equals("IN") && !td2DepPOS.equals("TO") || !td2Dep.value().equals(td1Dep.value()) || (possibles2 = (Set)map.get(td2Dep)) == null) continue;
                    for (TypedDependency td3 : possibles2) {
                        TreeGraphNode td3Dep = td3.dep();
                        String td3DepPOS = td3Dep.parent().value();
                        if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT || prep2Dep != null || td3DepPOS.equals("RB") || td3DepPOS.equals("IN") || td3DepPOS.equals("TO"))) {
                            prep2Dep = td3;
                            continue;
                        }
                        otherDtrs.add(td3);
                    }
                    continue;
                }
                td2Dep = td2.dep();
                td2DepPOS = td2Dep.parent().value();
                if (!(td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") || prepDep != null || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO"))) {
                    prepDep = td2;
                    continue;
                }
                otherDtrs.add(td2);
            }
            if (prepDep == null || ccDep == null || conjDep == null || prep2Dep == null) continue;
            boolean agent = false;
            if (td1Dep.value().equals("by") && (aux_pass_poss = (Set)map.get(td1.gov())) != null) {
                for (TypedDependency td_pass : aux_pass_poss) {
                    if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                    agent = true;
                }
            }
            if (agent) {
                tdNew = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), prepDep.dep());
                agent = false;
            } else {
                GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase());
                tdNew = new TypedDependency(reln, td1.gov(), prepDep.dep());
            }
            newTypedDeps.add(tdNew);
            TypedDependency tdNew2 = new TypedDependency(this.conjValue(ccDep.dep().value()), prepDep.dep(), prep2Dep.dep());
            newTypedDeps.add(tdNew2);
            td1.setReln(GrammaticalRelation.KILL);
            prepDep.setReln(GrammaticalRelation.KILL);
            ccDep.setReln(GrammaticalRelation.KILL);
            conjDep.setReln(GrammaticalRelation.KILL);
            prep2Dep.setReln(GrammaticalRelation.KILL);
            for (TypedDependency otd : otherDtrs) {
                otd.setGov(td1.gov());
            }
        }
        for (TypedDependency td1 : list) {
            boolean agent = false;
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                TypedDependency td3;
                Set aux_pass_poss;
                if (td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if (td1.reln() != GrammaticalRelation.DEPENDENT && td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO")) continue;
                if (td1Dep.value().equals("by") && (aux_pass_poss = (Set)map.get(td1.gov())) != null) {
                    for (TypedDependency td_pass : aux_pass_poss) {
                        if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                        agent = true;
                    }
                }
                if (agent) {
                    td3 = new TypedDependency(EnglishGrammaticalRelations.AGENT, td1.gov(), td2.dep());
                    agent = false;
                } else {
                    GrammaticalRelation reln = td1.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : EnglishGrammaticalRelations.getPrep(td1Dep.value().toLowerCase());
                    td3 = new TypedDependency(reln, td1.gov(), td2.dep());
                }
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (td1.reln() != GrammaticalRelation.KILL) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL || td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            boolean keep = true;
            if (td.reln() == GrammaticalRelation.KILL) {
                keep = false;
            } else if (td.reln() == EnglishGrammaticalRelations.POSSESSIVE_MODIFIER) {
                keep = false;
                TreeGraphNode dep = td.dep();
                for (TypedDependency typedD : list) {
                    if (!typedD.gov().equals(dep)) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private void collapseMultiwordPreps(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            for (TypedDependency td1 : list) {
                if (!td1.dep().value().equalsIgnoreCase(mwp[0])) continue;
                for (TypedDependency td2 : list) {
                    if (td2.gov() != td1.dep() && td2.gov() != td1.gov() || td2.reln().getSpecific() == null || !td2.reln().getSpecific().equals(mwp[1])) continue;
                    td1.setReln(GrammaticalRelation.KILL);
                    td2.setReln(GrammaticalRelation.KILL);
                    GrammaticalRelation gr = EnglishGrammaticalRelations.getPrep(mwp[0] + "_" + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, td1.gov(), td2.dep()));
                }
            }
        }
        for (TypedDependency td : list) {
            if (td.reln() == GrammaticalRelation.KILL) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        if (sentFileName == null && treeFileName == null) {
            try {
                System.err.println("Usage: java EnglishGrammaticalStructure [-sentFile file|-treeFile file] [-testGraph]");
                PennTreeReader tr = new PennTreeReader((Reader)new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"), new LabeledScoredTreeFactory());
                ((AbstractCollection)tb).add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else if (treeFileName != null) {
            tb.loadPath(treeFileName);
        } else {
            String[] opts = new String[]{"-retainNPTmpSubcategories"};
            LexicalizedParser lp = new LexicalizedParser("/u/nlp/data/lexparser/englishPCFG.ser.gz");
            lp.setOptionFlags(opts);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(sentFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("Cannot find " + sentFileName);
                System.exit(1);
            }
            try {
                String line;
                System.out.println("Processing sentence file " + sentFileName);
                while ((line = reader.readLine()) != null) {
                    System.out.println("Processing sentence: " + line);
                    PTBTokenizer ptb = new PTBTokenizer(new StringReader(line));
                    List words = ptb.tokenize();
                    lp.parse(words);
                    Tree parseTree = lp.getBestParse();
                    ((AbstractCollection)tb).add(parseTree);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("IOexception reading key file " + sentFileName);
                System.exit(1);
            }
        }
        System.out.println("Phrase structure tree, then dependencies, then collapsed dependencies");
        for (Tree t : tb) {
            System.out.println("==================================================");
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(t);
            t.pennPrint();
            System.out.println("----------------------------");
            System.out.println(gs);
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependencies(true), "\n"));
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(false), "\n"));
        }
    }
}

