/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import java.util.HashMap;
import java.util.Iterator;

class TagCount {
    private HashMap<String, Integer> map = new HashMap();
    private int ambClassId = -1;
    String[] getTagsCache = null;
    boolean dirty = true;
    private static final String NULL_SYMBOL = "<<NULL>>";

    TagCount() {
    }

    public void save(OutDataStreamFile rf) {
        try {
            rf.writeInt(this.map.size());
            for (String tag : this.map.keySet()) {
                if (tag == null) {
                    rf.writeUTF(NULL_SYMBOL);
                } else {
                    rf.writeUTF(tag);
                }
                rf.writeInt(this.map.get(tag));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAmbClassId(int ambClassId) {
        this.ambClassId = ambClassId;
    }

    public int getAmbClassId() {
        return this.ambClassId;
    }

    public void read(InDataStreamFile rf) {
        try {
            int numTags = rf.readInt();
            this.map = new HashMap();
            for (int i = 0; i < numTags; ++i) {
                String tag = rf.readUTF();
                int count = rf.readInt();
                if (tag.equals(NULL_SYMBOL)) {
                    tag = null;
                }
                this.map.put(tag, count);
            }
            this.dirty = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            this.read(rf);
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print() {
        try {
            for (String tag : this.map.keySet()) {
                int count = this.map.get(tag);
                System.out.print(count + " " + tag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int sum() {
        int s = 0;
        Iterator<Integer> i = this.map.values().iterator();
        while (i.hasNext()) {
            s += i.next().intValue();
        }
        return s;
    }

    public void add(String tag) {
        int val = this.map.get(tag) != null ? this.map.get(tag) : 0;
        this.map.put(tag, val + 1);
        this.dirty = true;
    }

    public int get(String tag) {
        if (this.map.get(tag) != null) {
            return this.map.get(tag);
        }
        return 0;
    }

    public String[] getTags() {
        if (this.dirty) {
            this.getTagsCache = this.map.keySet().toArray(new String[0]);
            this.dirty = false;
        }
        return this.getTagsCache;
    }

    public int numTags() {
        return this.map.size();
    }

    public String getFirstTag() {
        String maxTag = null;
        int max = 0;
        for (String tag : this.map.keySet()) {
            int count = this.map.get(tag);
            if (count <= max) continue;
            maxTag = tag;
            max = count;
        }
        return maxTag;
    }

    public String toString() {
        return this.map.toString();
    }
}

