/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.lexparser.WordSegmenter;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import java.io.Reader;
import java.util.Iterator;

public class WordSegmentingTokenizer
extends AbstractTokenizer {
    private Iterator wordIter;
    private Tokenizer tok;
    private WordSegmenter wordSegmenter;

    protected Object getNext() {
        while (this.wordIter == null || !this.wordIter.hasNext()) {
            if (!this.tok.hasNext()) {
                return null;
            }
            String s = ((Word)this.tok.next()).word();
            if (s == null) {
                return null;
            }
            Sentence se = this.segmentWords(s);
            this.wordIter = se.iterator();
        }
        return this.wordIter.next();
    }

    public WordSegmentingTokenizer(WordSegmenter wordSegmenter, Reader r) {
        this.wordSegmenter = wordSegmenter;
        this.tok = new WhitespaceTokenizer(r);
    }

    public Sentence segmentWords(String s) {
        return this.wordSegmenter.segmentWords(s);
    }

    public static TokenizerFactory factory(WordSegmenter wordSegmenter) {
        return new WordSegmentingTokenizerFactory(wordSegmenter);
    }

    private static class WordSegmentingTokenizerFactory
    implements TokenizerFactory {
        WordSegmenter wordSegmenter;

        public WordSegmentingTokenizerFactory(WordSegmenter wordSegmenter) {
            this.wordSegmenter = wordSegmenter;
        }

        public Iterator getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        public Tokenizer getTokenizer(Reader r) {
            return new WordSegmentingTokenizer(this.wordSegmenter, r);
        }
    }
}

