/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.process.AbstractTokenizer;
import java.io.IOException;
import java.io.StreamTokenizer;

public class TokenizerAdapter
extends AbstractTokenizer {
    protected StreamTokenizer st;
    protected String eolString = "<EOL>";

    public TokenizerAdapter(StreamTokenizer st) {
        this.st = st;
    }

    public Object getNext() {
        try {
            int nextToken = this.st.nextToken();
            switch (nextToken) {
                case 10: {
                    return this.eolString;
                }
                case -1: {
                    return null;
                }
                case -3: {
                    return this.st.sval;
                }
                case -2: {
                    return Double.toString(this.st.nval);
                }
            }
            char[] t = new char[]{(char)nextToken};
            return new String(t);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setEolString(String eolString) {
        if (eolString == null) {
            throw new IllegalArgumentException("eolString cannot be null");
        }
        this.eolString = eolString;
    }

    public boolean isEol(String str) {
        return this.eolString.equals(str);
    }
}

