/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.CNFTransformers;
import edu.stanford.nlp.parser.lexparser.PostSplitter;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotator;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.parser.lexparser.TreeNullAnnotator;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class TreeAnnotatorAndBinarizer
implements TreeTransformer {
    TreeFactory tf;
    private TreebankLanguagePack tlp;
    private TreeTransformer annotator;
    private TreeTransformer binarizer;
    private TreeTransformer postSplitter;
    private boolean forceCNF;

    public TreeAnnotatorAndBinarizer(TreebankLangParserParams tlpParams, boolean forceCNF, boolean insideFactor, boolean doSubcategorization) {
        this(tlpParams.headFinder(), tlpParams.headFinder(), tlpParams, forceCNF, insideFactor, doSubcategorization);
    }

    public TreeAnnotatorAndBinarizer(HeadFinder annotationHF, HeadFinder binarizationHF, TreebankLangParserParams tlpParams, boolean forceCNF, boolean insideFactor, boolean doSubcategorization) {
        this.annotator = doSubcategorization ? new TreeAnnotator(annotationHF, tlpParams) : new TreeNullAnnotator(annotationHF);
        this.binarizer = new TreeBinarizer(binarizationHF, tlpParams.treebankLanguagePack(), insideFactor, Train.markovFactor, Train.markovOrder, Train.compactGrammar() > 0, Train.compactGrammar() > 1, Train.HSEL_CUT, Train.markFinalStates);
        if (Train.selectivePostSplit) {
            this.postSplitter = new PostSplitter(tlpParams);
        }
        this.tf = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
        this.tlp = tlpParams.treebankLanguagePack();
        this.forceCNF = forceCNF;
    }

    public void dumpStats() {
        if (Train.selectivePostSplit) {
            ((PostSplitter)this.postSplitter).dumpStats();
        }
    }

    public void setDoSelectiveSplit(boolean doSelectiveSplit) {
        ((TreeBinarizer)this.binarizer).setDoSelectiveSplit(doSelectiveSplit);
    }

    public void addRoot(Tree t) {
        if (t.isLeaf()) {
            System.err.println("Warning: tree is leaf: " + t);
            t = this.tf.newTreeNode(this.tlp.startSymbol(), Collections.singletonList(t));
        }
        t.setLabel(new CategoryWordTag(this.tlp.startSymbol(), ".$.", ".$$."));
        ArrayList<Tree> preTermChildList = new ArrayList<Tree>();
        Tree boundaryTerm = this.tf.newLeaf(new StringLabel(".$."));
        preTermChildList.add(boundaryTerm);
        Tree boundaryPreTerm = this.tf.newTreeNode(new CategoryWordTag(".$$.", ".$.", ".$$."), preTermChildList);
        List<Tree> childList = t.getChildrenAsList();
        childList.add(boundaryPreTerm);
        t.setChildren(childList);
    }

    public Tree transformTree(Tree t) {
        if (Train.printTreeTransformations) {
            Train.printTrainTree(null, "ORIGINAL TREE:", t);
        }
        Tree trTree = this.annotator.transformTree(t);
        if (Train.selectivePostSplit) {
            trTree = this.postSplitter.transformTree(trTree);
        }
        if (Train.printTreeTransformations) {
            Train.printTrainTree(Train.printAnnotatedPW, "ANNOTATED TREE:", trTree);
        }
        this.addRoot(trTree);
        Tree binarizedTree = this.binarizer.transformTree(trTree);
        if (Train.printTreeTransformations) {
            Train.printTrainTree(Train.printBinarizedPW, "BINARIZED TREE:", binarizedTree);
        }
        if (this.forceCNF) {
            binarizedTree = new CNFTransformers.ToCNFTransformer().transformTree(binarizedTree);
        }
        return binarizedTree;
    }
}

