/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class Features {
    private ArrayList f = new ArrayList();
    private static int maxValue = 11000000;

    public Features() {
    }

    public void add(Feature m) {
        this.f.add(m);
    }

    public void removeLast() {
        this.f.remove(this.f.size() - 1);
    }

    public Feature get(int index) {
        return (Feature)this.f.get(index);
    }

    public int size() {
        return this.f.size();
    }

    public Experiments domain() {
        this.get(0);
        return Feature.domain;
    }

    public void clean() {
    }

    public void print() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).print();
            ++i;
        }
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rF = new OutDataStreamFile(filename);
            rF.writeInt(this.size());
            int i = 0;
            while (i < this.size()) {
                this.get(i).save(rF);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Features(String filename, Experiments domain) {
        Exception e1 = new Exception("Incorrect data file format!");
        Index instanceIndex = domain.createIndex();
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while (!(s = in.readLine()).equals("<features>")) {
            }
            if (s == null) {
                throw e1;
            }
            s = in.readLine();
            if (!s.startsWith("<fSize>")) {
                throw e1;
            }
            if (!s.endsWith("</fSize>")) {
                throw e1;
            }
            int index1 = s.indexOf(">");
            int index2 = s.lastIndexOf("<");
            String fSt = s.substring(index1 + 1, index2);
            System.out.println(fSt);
            int number = new Integer(fSt);
            System.out.println("fSize is " + number);
            int[] arrIndexes = new int[maxValue];
            double[] arrValues = new double[maxValue];
            int f = 0;
            while (f < number) {
                String line = in.readLine();
                int indSp = -1;
                int current = 0;
                while ((indSp = line.indexOf(" ")) > -1) {
                    int x = new Integer(line.substring(0, indSp));
                    if ((indSp = (line = line.substring(indSp + 1)).indexOf(" ")) == -1) {
                        indSp = line.length();
                    }
                    int y = new Integer(line.substring(0, indSp));
                    if ((indSp = (line = line.substring(indSp + 1)).indexOf(" ")) == -1) {
                        indSp = line.length();
                    }
                    double val = new Double(line.substring(0, indSp));
                    if (indSp < line.length()) {
                        line = line.substring(indSp + 1);
                    }
                    arrIndexes[current] = instanceIndex.indexOf(new IntPair(x, y));
                    arrValues[current] = val;
                    ++current;
                }
                int[] indValues = new int[current];
                double[] values = new double[current];
                int j = 0;
                while (j < current) {
                    indValues[j] = arrIndexes[j];
                    values[j] = arrValues[j];
                    ++j;
                }
                Feature bf = new Feature(domain, indValues, values, instanceIndex);
                this.add(bf);
                ++f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rF = new InDataStreamFile(filename);
            int numFeats = rF.readInt();
            int i = 0;
            while (i < numFeats) {
                Feature tF = new Feature();
                tF.read(rF);
                this.add(tF);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

