/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpEncodingUtils {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static Pattern CHARSET_ENCODING_PATTERN = Pattern.compile("charset=(.+)");

    public static String checkedEncodeUtf8(String string) {
        try {
            return URLEncoder.encode(string, ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String getContentTypeCharset(String contentType) {
        Matcher matcher = CHARSET_ENCODING_PATTERN.matcher(contentType);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }
}

