/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relation;

import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.core.rep.relation.ILexicalMarker;
import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.core.rep.relation.RelationRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.util.Debug;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorHighlighter;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalMarkerHighlighter
extends StoryEditorHighlighter<IStoryEditor>
implements IModelListener {
    private static final WeakHashMap<IStoryEditor, LexicalMarkerHighlighter> map = new WeakHashMap();

    public static LexicalMarkerHighlighter getHighlighter(final IStoryEditor editor) {
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        LexicalMarkerHighlighter h = map.get(editor);
        if (h != null) {
            return h;
        }
        final LexicalMarkerHighlighter hl = new LexicalMarkerHighlighter(editor);
        editor.getTextViewer().getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                map.remove(editor);
                hl.dispose();
            }
        });
        map.put(editor, hl);
        return hl;
    }

    protected LexicalMarkerHighlighter(IStoryEditor targetEditor) {
        super(targetEditor, "edu.mit.story.ui.annotation.target1", DiscourseUIMessages.ANNOTATION_LexicalMarker2_message);
        this.getEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    protected IHasPositionSet<? extends IHasPosition> getAnnotationPositions() {
        IStoryData data = this.getEditor().getStoryModel().getData();
        if (!data.supports(RelationRep.getInstance())) {
            return null;
        }
        IDescSet descs = data.getDescriptions(RelationRep.getInstance());
        int size = descs.size();
        if (size == 0) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc desc : descs) {
            IHasPosition p = this.calculateLexMarkerPosition(desc);
            if (p == null) {
                Debug.out((String)("null position at " + desc));
                continue;
            }
            result.add((Object)p);
        }
        return result;
    }

    protected IHasPosition calculateLexMarkerPosition(IDesc d) {
        IRelation r = (IRelation)d.getData();
        ILexicalMarker lm = r.getLexicalMarker();
        IHasPosition p = lm.calculatePosition();
        if (p != null) {
            return p;
        }
        List args = r.getArguments();
        if (args.size() < 2) {
            return null;
        }
        p = ((IArgument)args.get(0)).calculatePosition();
        int offset = p.getRightOffset();
        p = ((IArgument)args.get(1)).calculatePosition();
        int rightOffset = p.getOffset();
        return new SimplePosition(offset, rightOffset - offset);
    }

    public void modelChanged(StoryChangeEvent e) {
        if (e.affects(RelationRep.getInstance())) {
            this.refreshHighlighting();
        }
    }
}

