/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.content;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.RefPair;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.model.IReferentModel;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;

public class ReferentContentProvider
extends StoryEditorContentProvider {
    private boolean sortByReference = false;

    public ReferentContentProvider() {
        this(null);
    }

    public ReferentContentProvider(IStoryEditor input) {
        super(ReferentRep.getInstance(), input, DiscourseUIMessages.MSG_NoReferents);
    }

    public void setSortByReference(boolean value) {
        if (this.sortByReference == value) {
            return;
        }
        this.sortByReference = value;
    }

    public boolean isSortingByReference() {
        return this.sortByReference;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof RefPair) {
            return true;
        }
        if (element instanceof IDesc) {
            IDesc desc = (IDesc)element;
            if (ReferentRep.getInstance().isType((IHasRep)desc)) {
                element = desc.getData();
            }
        }
        if (element instanceof IReferentModel) {
            IReferentModel model = (IReferentModel)element;
            return !model.getReferences().isEmpty();
        }
        if (element instanceof IReferent) {
            IReferent entity = (IReferent)element;
            return !entity.getReferences().isEmpty();
        }
        if (element instanceof Object[]) {
            return ((Object[])element).length > 0;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parent) {
        if (this.sortByReference && parent instanceof IStoryModel) {
            IStoryModel model = (IStoryModel)parent;
            HasPositionSet result = new HasPositionSet();
            for (IDesc desc : model.getData().getDescriptions(ReferentRep.getInstance())) {
                for (IReference ref : ((IReferent)desc.getData()).getReferences()) {
                    result.add((Object)new RefPair(desc, ref));
                }
            }
            return result.toArray();
        }
        if (parent instanceof IDesc) {
            IDesc desc = (IDesc)parent;
            if (ReferentRep.getInstance().isType((IHasRep)desc)) {
                parent = desc.getData();
            }
        }
        if (parent instanceof RefPair) {
            RefPair pair = (RefPair)parent;
            return new Object[]{pair.desc};
        }
        if (parent instanceof IReferent) {
            IReferent ref = (IReferent)parent;
            Object[] props = null;
            int size = ref.getReferences().size() + (props != null && props.length > 0 ? 1 : 0);
            Object[] result = new Object[size];
            int idx = 0;
            for (IReference r : ref.getReferences()) {
                result[idx++] = r;
            }
            if (props != null && props.length > 0) {
                result[idx++] = props;
            }
            return result;
        }
        if (parent instanceof Object[]) {
            return (Object[])parent;
        }
        return super.getChildren(parent);
    }
}

