/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions.delegates;

import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.AddReferenceChange;
import edu.mit.discourse.ui.dialogs.ReferenceFinderDialog;
import edu.mit.discourse.ui.dialogs.ReferentSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddReferencesByPattern
extends AbstractDelegate {
    IStoryEditor currentEditor;

    public void run(IAction action) {
        if (!AddReferencesByPattern.addByPattern(this.currentEditor, (Object)this)) {
            PlatformUI.getWorkbench().getDisplay().beep();
        }
    }

    public void setActivePart(IWorkbenchPart activePart) {
        this.currentEditor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
    }

    public void updateAction(IAction action) {
        boolean enabled = this.currentEditor != null && this.currentEditor.getStoryModel().supports(ReferentRep.getInstance());
        action.setEnabled(enabled);
    }

    public void dispose() {
        this.currentEditor = null;
        super.dispose();
    }

    public static boolean addByPattern(IStoryEditor editor, Object source) {
        Date start = new Date();
        IDesc refDesc = ReferentSelectionDialog.open(editor);
        if (refDesc == null) {
            return false;
        }
        if (!ReferentRep.getInstance().isType((IHasRep)refDesc)) {
            return false;
        }
        IReferent ref = (IReferent)refDesc.getData();
        List<IHasPosition> newPs = ReferenceFinderDialog.open(editor, ref);
        if (newPs == null || newPs.isEmpty()) {
            return false;
        }
        ArrayList<List<IHasPosition>> newRefs = new ArrayList<List<IHasPosition>>(newPs.size());
        for (IHasPosition newP : newPs) {
            newRefs.add(Collections.singletonList(newP));
        }
        Timing editingTime = new Timing(start, "user");
        AddReferenceChange change = new AddReferenceChange(newRefs, refDesc, (ITiming)editingTime);
        editor.getStoryModel().applyChange(source, (IModelChange)change, false);
        return true;
    }

    public static boolean addByPattern(IStoryEditor editor, IDesc refDesc, Object source) {
        Date start = new Date();
        if (!ReferentRep.getInstance().isType((IHasRep)refDesc)) {
            return false;
        }
        IReferent ref = (IReferent)refDesc.getData();
        List<IHasPosition> newPs = ReferenceFinderDialog.open(editor, ref);
        if (newPs == null || newPs.isEmpty()) {
            return false;
        }
        ArrayList<List<IHasPosition>> newRefs = new ArrayList<List<IHasPosition>>(newPs.size());
        for (IHasPosition newP : newPs) {
            newRefs.add(Collections.singletonList(newP));
        }
        Timing editingTime = new Timing(start, "user");
        AddReferenceChange change = new AddReferenceChange(newRefs, refDesc, (ITiming)editingTime);
        editor.getStoryModel().applyChange(source, (IModelChange)change, false);
        return true;
    }
}

