/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.OtherBreakpointCategory;

public class BreakpointContainer
extends PlatformObject {
    private IAdaptable fCategory;
    private IBreakpointOrganizer fOrganizer;
    private List fBreakpoints;
    private Map fCategoriesToContainers;
    private IBreakpointOrganizer[] fNesting;

    public BreakpointContainer(IAdaptable category, IBreakpointOrganizer organizer, IBreakpointOrganizer[] nesting) {
        IAdaptable[] emptyCategories;
        this.fCategory = category;
        this.fOrganizer = organizer;
        this.fBreakpoints = new ArrayList();
        this.fNesting = nesting;
        this.fCategoriesToContainers = new HashMap();
        if (nesting != null && nesting.length > 0 && (emptyCategories = nesting[0].getCategories()) != null) {
            int i = 0;
            while (i < emptyCategories.length) {
                IAdaptable empty = emptyCategories[i];
                BreakpointContainer container = (BreakpointContainer)((Object)this.fCategoriesToContainers.get(empty));
                if (container == null) {
                    container = new BreakpointContainer(empty, nesting[0], null);
                    this.fCategoriesToContainers.put(empty, container);
                }
                ++i;
            }
        }
    }

    public void addBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoints.add(breakpoint);
        if (this.fNesting != null && this.fNesting.length > 0) {
            IBreakpointOrganizer organizer = this.fNesting[0];
            IAdaptable[] categories = organizer.getCategories(breakpoint);
            if (categories == null || categories.length == 0) {
                categories = OtherBreakpointCategory.getCategories(organizer);
            }
            int i = 0;
            while (i < categories.length) {
                IAdaptable category = categories[i];
                BreakpointContainer container = (BreakpointContainer)((Object)this.fCategoriesToContainers.get(category));
                if (container == null) {
                    IBreakpointOrganizer[] nesting = null;
                    if (this.fNesting.length > 1) {
                        nesting = new IBreakpointOrganizer[this.fNesting.length - 1];
                        System.arraycopy(this.fNesting, 1, nesting, 0, nesting.length);
                    }
                    container = new BreakpointContainer(category, organizer, nesting);
                    this.fCategoriesToContainers.put(category, container);
                }
                container.addBreakpoint(breakpoint);
                ++i;
            }
        }
    }

    public IBreakpoint[] getBreakpoints() {
        return this.fBreakpoints.toArray(new IBreakpoint[this.fBreakpoints.size()]);
    }

    public IAdaptable getCategory() {
        return this.fCategory;
    }

    public Object[] getChildren() {
        if (this.fCategoriesToContainers.isEmpty()) {
            return this.getBreakpoints();
        }
        return this.getContainers();
    }

    public BreakpointContainer[] getContainers() {
        Collection collection = this.fCategoriesToContainers.values();
        return collection.toArray(new BreakpointContainer[collection.size()]);
    }

    public IBreakpointOrganizer getOrganizer() {
        return this.fOrganizer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreakpointContainer) {
            BreakpointContainer container = (BreakpointContainer)((Object)obj);
            return this.getCategory().equals(container.getCategory());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getCategory().hashCode();
    }

    public boolean contains(IBreakpoint breakpoint) {
        return this.fBreakpoints.contains(breakpoint);
    }

    public BreakpointContainer[] getContainers(IBreakpoint breakpoint) {
        if (this.contains(breakpoint)) {
            BreakpointContainer[] containers = this.getContainers();
            if (containers.length == 0) {
                return new BreakpointContainer[]{this};
            }
            ArrayList<BreakpointContainer> list = new ArrayList<BreakpointContainer>();
            int i = 0;
            while (i < containers.length) {
                BreakpointContainer container = containers[i];
                BreakpointContainer[] subcontainers = container.getContainers(breakpoint);
                if (subcontainers != null) {
                    int j = 0;
                    while (j < subcontainers.length) {
                        list.add(subcontainers[j]);
                        ++j;
                    }
                }
                ++i;
            }
            return list.toArray(new BreakpointContainer[list.size()]);
        }
        return null;
    }
}

