/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.label;

import edu.mit.jwi.item.IWord;
import edu.mit.wordnet.ui.WordnetUIMessages;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class WordLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int IDX_COLUMN_SYNONYM = 0;
    public static final int IDX_COLUMN_GLOSS = 1;

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof IWord)) {
            return null;
        }
        IWord word = (IWord)element;
        switch (columnIndex) {
            case 0: {
                return WordLabelProvider.getSynonymList(word);
            }
            case 1: {
                return word.getSynset().getGloss();
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (!(element instanceof IWord)) {
            return WordnetUIMessages.MSG_NotAWord;
        }
        IWord word = (IWord)element;
        StringBuilder sb = new StringBuilder();
        String list = WordLabelProvider.getSynonymList(word);
        if (list.length() > 0) {
            sb.append("[");
            sb.append(list);
            sb.append("] ");
        }
        sb.append(word.getSynset().getGloss());
        return sb.toString();
    }

    public static String getSynonymList(IWord word) {
        StringBuilder sb = new StringBuilder();
        ArrayList synonyms = new ArrayList(word.getSynset().getWords());
        synonyms.remove(word);
        sb.append(word.getLemma());
        if (!synonyms.isEmpty()) {
            sb.append(", ");
        }
        Iterator i = synonyms.iterator();
        while (i.hasNext()) {
            sb.append(((IWord)i.next()).getLemma());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

