/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.sentence.problems;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncoveredTokenProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.sentence.problem.uncoveredToken";

    public UncoveredTokenProblem(IDesc desc, String buildRuleID) {
        this(Collections.singleton(desc), buildRuleID);
    }

    public UncoveredTokenProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(TokenRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("uncovered token");
        this.setSeverity(2);
        this.setDescs(descs);
        IDescSet ds = this.getDescs().getDescriptions(TokenRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)ds.first());
        this.setCheck(ID);
        StringBuilder sb = new StringBuilder();
        if (ds.size() == 1) {
            IDesc d = (IDesc)ds.first();
            IToken token = (IToken)d.getData();
            sb.append("The token '");
            sb.append(token.getSurface());
            sb.append("' is not covered by a sentence");
        } else {
            sb.append("There are ");
            sb.append(Integer.toString(ds.size()));
            sb.append(" tokens that are not covered by sentences");
        }
        this.setDescription(sb.toString());
    }
}

