/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.Token;
import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.colloc.Colloc;
import edu.mit.parsing.core.rep.colloc.CollocDetectorManager;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.ICollocDetector;
import edu.mit.parsing.core.rep.colloc.IndexedColloc;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollocDefaultFactory
extends AbstractDescFactory2<IndexedColloc> {
    private ICollocDetector detector;

    protected boolean doInit(IStoryModel data) {
        String id = (String)this.getConfiguration().get((Object)"detector");
        if (id == null) {
            return false;
        }
        this.detector = (ICollocDetector)CollocDetectorManager.getInstance().create(id);
        if (this.detector == null) {
            return false;
        }
        this.detector.init();
        return true;
    }

    public void dispose(IStoryModel model) {
        if (this.detector != null) {
            this.detector.dispose();
        }
        this.detector = null;
    }

    public CollocDefaultFactory() {
        super(CollocRep.getInstance(), new IRep[]{TokenRep.getInstance(), SentenceRep.getInstance()});
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        IHasPositionSet sentRegions;
        Change tokenChange = event.getChange(TokenRep.getInstance());
        Change posChange = event.getChange(POSRep.getInstance());
        Change sentChange = event.getChange(SentenceRep.getInstance());
        if (tokenChange == null && sentChange == null && posChange == null) {
            return null;
        }
        IHasPositionSet tokenRegions = tokenChange == null ? null : tokenChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet posRegions = posChange == null ? null : posChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet iHasPositionSet = sentRegions = sentChange == null ? null : sentChange.getChanges((IFlag)Flag.DESCS);
        if (!(tokenRegions != null && !tokenRegions.isEmpty() || sentRegions != null && !sentRegions.isEmpty() || posRegions != null && !posRegions.isEmpty())) {
            return null;
        }
        DistinctRegionSet result = new DistinctRegionSet();
        IDescSet sentDescs = event.provider.getData().getDescriptions(SentenceRep.getInstance());
        if (tokenRegions != null) {
            for (IHasPosition region : tokenRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
            }
        }
        if (posRegions != null) {
            for (IHasPosition region : posRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
            }
        }
        if (sentRegions != null) {
            result.addAll((Collection)sentRegions);
        }
        return result;
    }

    protected IHasPositionSet<IndexedColloc> calculateData(IHasPosition region, IStoryModel provider) {
        IDescSet sentDescs = provider.getData().getDescriptions(SentenceRep.getInstance()).openSet(region);
        HasPositionSet result = null;
        for (IDesc sentDesc : sentDescs) {
            IHasPositionSet<IndexedColloc> data = this.detectCollocations((IHasPosition)sentDesc, provider);
            if (data == null) continue;
            if (result == null) {
                result = new HasPositionSet();
            }
            result.addAll(data);
        }
        return result;
    }

    protected IHasPositionSet<IndexedColloc> detectCollocations(IHasPosition sentence, IStoryModel provider) {
        IDescSet tokenDs = provider.getData().getDescriptions(TokenRep.getInstance()).openSet(sentence);
        ArrayList<TokenDesc> jmweSentence = new ArrayList<TokenDesc>(tokenDs.size());
        for (IDesc tokenD : tokenDs) {
            jmweSentence.add(new TokenDesc(tokenD, provider.getData()));
        }
        List detected = this.detector.detect(jmweSentence);
        if (detected == null || detected.isEmpty()) {
            return null;
        }
        Function<TokenDesc, IDesc> jmweTokenToDesc = new Function<TokenDesc, IDesc>(){

            public IDesc apply(TokenDesc input) {
                return input.getWorkbenchToken();
            }
        };
        HasPositionSet result = new HasPositionSet();
        for (IMWE mwe : detected) {
            Collection tokens = Collections2.transform((Collection)mwe.getTokens(), (Function)jmweTokenToDesc);
            result.add((Object)new IndexedColloc(new Colloc(tokens)));
        }
        return result;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new CollocFactoryConfigDescriptor();
    }

    protected String getText(IDesc tokenD) {
        IToken t = (IToken)tokenD.getData();
        return t.getSurface();
    }

    protected String getTagStr(IDesc tokenD, IStoryData data) {
        IPosTag tag;
        if (!data.supports(POSRep.getInstance())) {
            return "?";
        }
        IDescSet posDs = data.getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)tokenD);
        TreeSet<IDesc> actualPosDs = new TreeSet<IDesc>();
        for (IDesc posD : posDs) {
            tag = (IPosTag)posD.getData();
            if (tag.getWord() != tokenD) continue;
            actualPosDs.add(posD);
        }
        if (actualPosDs.size() != 1) {
            return "?";
        }
        tag = (IPosTag)((IDesc)actualPosDs.first()).getData();
        return tag.getTag().getTagString();
    }

    protected String[] getStemStrs(IDesc tokenD, IStoryData data) {
        if (!data.supports(StemRep.getInstance())) {
            return new String[0];
        }
        IDescSet stemDs = data.getDescriptions(StemRep.getInstance()).matchSet((IHasPosition)tokenD);
        ArrayList<String> stems = new ArrayList<String>(stemDs.size());
        for (IDesc stemD : stemDs) {
            IStem stem = (IStem)stemD.getData();
            if (stem.getWord() != tokenD) continue;
            stems.add(stem.getStem());
        }
        return stems.toArray(new String[stems.size()]);
    }

    public static class CollocFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public CollocFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("detector", ParsingMessages.FACTORY_PARAM_NAME_CollocDetector, ParsingMessages.FACTORY_PARAM_DESC_CollocDetector, (IValidator)new ManagerBackedListValidator(CollocDetectorManager.getInstance()), true, "DefaultCollocDetectorID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }

    protected class TokenDesc
    extends Token {
        private final IDesc tokenD;

        public TokenDesc(IDesc tokenD, IStoryData data) {
            super(CollocDefaultFactory.this.getText(tokenD), CollocDefaultFactory.this.getTagStr(tokenD, data), CollocDefaultFactory.this.getStemStrs(tokenD, data));
            if (tokenD == null) {
                throw new NullPointerException();
            }
            this.tokenD = tokenD;
        }

        public IDesc getWorkbenchToken() {
            return this.tokenD;
        }
    }
}

