/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.morph;

import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.IStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStemmer
implements IStemmer {
    public static final String underscore = "_";
    Pattern whitespace = Pattern.compile("\\s+");
    public static final String SUFFIX_ches = "ches";
    public static final String SUFFIX_ed = "ed";
    public static final String SUFFIX_es = "es";
    public static final String SUFFIX_est = "est";
    public static final String SUFFIX_er = "er";
    public static final String SUFFIX_ful = "ful";
    public static final String SUFFIX_ies = "ies";
    public static final String SUFFIX_ing = "ing";
    public static final String SUFFIX_men = "men";
    public static final String SUFFIX_s = "s";
    public static final String SUFFIX_ses = "ses";
    public static final String SUFFIX_shes = "shes";
    public static final String SUFFIX_xes = "xes";
    public static final String SUFFIX_zes = "zes";
    public static final String ENDING_null = "";
    public static final String ENDING_ch = "ch";
    public static final String ENDING_e = "e";
    public static final String ENDING_man = "man";
    public static final String ENDING_s = "s";
    public static final String ENDING_sh = "sh";
    public static final String ENDING_x = "x";
    public static final String ENDING_y = "y";
    public static final String ENDING_z = "z";
    String[][] nounMappings = new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "ch"}, {"shes", "sh"}, {"men", "man"}, {"ies", "y"}};
    String[][] verbMappings = new String[][]{{"s", ""}, {"ies", "y"}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}};
    String[][] adjMappings = new String[][]{{"er", "e"}, {"er", ""}, {"est", "e"}, {"est", ""}};

    @Override
    public List<String> findStems(String word, POS pos) {
        if (pos == null) {
            return this.findStems(word);
        }
        word = this.normalize(word);
        boolean isCollocation = word.contains(underscore);
        if (pos == POS.NOUN) {
            return isCollocation ? this.getNounCollocationRoots(word) : this.stripNounSuffix(word);
        }
        if (pos == POS.VERB) {
            return isCollocation ? this.getVerbCollocationRoots(word) : this.stripVerbSuffix(word);
        }
        if (pos == POS.ADJECTIVE) {
            return this.stripAdjectiveSuffix(word);
        }
        return Collections.emptyList();
    }

    public List<String> findStems(String word) {
        word = this.normalize(word);
        TreeSet<String> result = new TreeSet<String>();
        List<String> roots = this.stripNounSuffix(word);
        if (roots != null) {
            result.addAll(roots);
        }
        if ((roots = this.stripVerbSuffix(word)) != null) {
            result.addAll(roots);
        }
        if ((roots = this.stripAdjectiveSuffix(word)) != null) {
            result.addAll(roots);
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected String normalize(String word) {
        for (int i = 0; i < word.length(); ++i) {
            if (!Character.isWhitespace(word.charAt(i))) continue;
            word = this.whitespace.matcher(word).replaceAll(underscore);
        }
        return word.toLowerCase();
    }

    protected List<String> stripNounSuffix(String noun) {
        int idx;
        String word = noun;
        boolean endsWithFUL = false;
        if (noun.endsWith(SUFFIX_ful)) {
            endsWithFUL = true;
            idx = word.lastIndexOf(SUFFIX_ful);
            word = noun.substring(0, idx);
        }
        TreeSet<String> result = new TreeSet<String>();
        StringBuilder sb = new StringBuilder();
        for (String[] mapping : this.nounMappings) {
            if (!word.endsWith(mapping[0])) continue;
            idx = word.lastIndexOf(mapping[0]);
            sb.setLength(0);
            for (int i = 0; i < idx; ++i) {
                sb.append(word.charAt(i));
            }
            sb.append(mapping[1]);
            if (endsWithFUL) {
                sb.append(SUFFIX_ful);
            }
            result.add(sb.toString());
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> getNounCollocationRoots(String composite) {
        String[] parts = composite.split(underscore);
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> rootSets = new ArrayList<List<String>>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            rootSets.add(this.findStems(parts[i], POS.NOUN));
        }
        HashSet<StringBuffer> poss = new HashSet<StringBuffer>();
        List rootSet = (List)rootSets.get(0);
        if (rootSet == null) {
            poss.add(new StringBuffer(parts[0]));
        } else {
            for (String root : rootSet) {
                poss.add(new StringBuffer(root));
            }
        }
        for (int i = 1; i < rootSets.size(); ++i) {
            rootSet = (List)rootSets.get(i);
            if (rootSet.isEmpty()) {
                for (StringBuffer p : poss) {
                    p.append(underscore);
                    p.append(parts[i]);
                }
                continue;
            }
            HashSet<StringBuffer> replace = new HashSet<StringBuffer>();
            for (StringBuffer p : poss) {
                for (String root : rootSet) {
                    StringBuffer newBuf = new StringBuffer();
                    newBuf.append(p.toString());
                    newBuf.append(underscore);
                    newBuf.append((Object)root);
                    replace.add(newBuf);
                }
            }
            poss.clear();
            poss.addAll(replace);
        }
        if (poss.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<String> result = new TreeSet<String>();
        for (StringBuffer p : poss) {
            result.add(p.toString());
        }
        return new ArrayList<String>(result);
    }

    protected List<String> stripVerbSuffix(String word) {
        TreeSet<String> result = new TreeSet<String>();
        for (String[] mapping : this.verbMappings) {
            if (!word.endsWith(mapping[0])) continue;
            int idx = word.lastIndexOf(mapping[0]);
            StringBuffer stem = new StringBuffer();
            for (int i = 0; i < idx; ++i) {
                stem.append(word.charAt(i));
            }
            stem.append(mapping[1]);
            result.add(stem.toString());
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> getVerbCollocationRoots(String composite) {
        String[] parts = composite.split(underscore);
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> rootSets = new ArrayList<List<String>>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            rootSets.add(this.findStems(parts[i], POS.VERB));
        }
        TreeSet<String> result = new TreeSet<String>();
        StringBuffer rootBuffer = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (rootSets.get(i) == null) continue;
            for (String partRoot : (List)rootSets.get(i)) {
                rootBuffer.replace(0, rootBuffer.length(), ENDING_null);
                for (int j = 0; j < parts.length; ++j) {
                    if (j == i) {
                        rootBuffer.append(partRoot);
                    } else {
                        rootBuffer.append(parts[j]);
                    }
                    if (j >= parts.length - 1) continue;
                    rootBuffer.append(underscore);
                }
                result.add(rootBuffer.toString());
            }
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    protected List<String> stripAdjectiveSuffix(String word) {
        TreeSet<String> result = new TreeSet<String>();
        for (String[] mapping : this.adjMappings) {
            if (!word.endsWith(mapping[0])) continue;
            int idx = word.lastIndexOf(mapping[0]);
            StringBuffer stem = new StringBuffer();
            for (int i = 0; i < idx; ++i) {
                stem.append(word.charAt(i));
            }
            stem.append(mapping[1]);
            result.add(stem.toString());
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }
}

