/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.data.parse.MisformattedLineException;
import edu.mit.jwi.item.ILexFile;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.LexFile;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.SenseKey;
import edu.mit.jwi.item.UnknownLexFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenseKeyParser
implements ILineParser<ISenseKey> {
    private static final char colon = ':';
    private static final char percent = '%';
    private static SenseKeyParser fInstance;

    public static SenseKeyParser getInstance() {
        if (fInstance == null) {
            fInstance = new SenseKeyParser();
        }
        return fInstance;
    }

    protected SenseKeyParser() {
    }

    @Override
    public ISenseKey parseLine(String key) {
        try {
            int begin = 0;
            int end = 0;
            end = key.indexOf(37);
            String lemma = key.substring(begin, end);
            begin = end + 1;
            end = key.indexOf(58, begin);
            int ss_type = Integer.parseInt(key.substring(begin, end));
            POS pos = POS.getPartOfSpeech(ss_type);
            boolean isAdjSat = POS.isAdjectiveSatellite(ss_type);
            begin = end + 1;
            end = key.indexOf(58, begin);
            int lex_filenum = Integer.parseInt(key.substring(begin, end));
            ILexFile lexFile = this.resolveLexicalFile(lex_filenum);
            begin = end + 1;
            end = key.indexOf(58, begin);
            int lex_id = Integer.parseInt(key.substring(begin, end));
            if (!isAdjSat) {
                return new SenseKey(lemma, lex_id, pos, lexFile, null, -1, key);
            }
            begin = end + 1;
            end = key.indexOf(58, begin);
            String head_word = key.substring(begin, end);
            begin = end + 1;
            int head_id = Integer.parseInt(key.substring(begin));
            return new SenseKey(lemma, lex_id, pos, lexFile, head_word, head_id, key);
        }
        catch (Exception e) {
            throw new MisformattedLineException(e);
        }
    }

    protected ILexFile resolveLexicalFile(int lexFileNum) {
        LexFile lexFile = LexFile.getLexicalFile(lexFileNum);
        return lexFile == null ? UnknownLexFile.getUnknownLexicalFile(lexFileNum) : lexFile;
    }
}

