/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.compare;

import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.data.compare.ILineComparator;
import edu.mit.jwi.data.parse.MisformattedLineException;
import java.util.regex.Pattern;

public class ExceptionLineComparator
implements ILineComparator {
    private static ExceptionLineComparator fInstance;
    private static final Pattern spacePattern;

    public static ExceptionLineComparator getInstance() {
        if (fInstance == null) {
            fInstance = new ExceptionLineComparator();
        }
        return fInstance;
    }

    protected ExceptionLineComparator() {
    }

    public int compare(String line1, String line2) {
        String[] words1 = spacePattern.split(line1);
        String[] words2 = spacePattern.split(line2);
        if (words1.length < 1) {
            throw new MisformattedLineException(line1);
        }
        if (words2.length < 1) {
            throw new MisformattedLineException(line2);
        }
        return words1[0].compareTo(words2[0]);
    }

    public ICommentDetector getCommentDetector() {
        return null;
    }

    static {
        spacePattern = Pattern.compile(" ");
    }
}

