/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.WordnetFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearchWordnetFile<T>
extends WordnetFile<T> {
    protected final Comparator<String> fComparator = this.getContentType().getLineComparator();

    public BinarySearchWordnetFile(File file, IContentType<T> contentType) throws IOException {
        super(file, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLine(String key) {
        ByteBuffer byteBuffer = this.fBuffer;
        synchronized (byteBuffer) {
            int start = 0;
            int stop = this.fBuffer.limit();
            int midpoint = (stop + start) / 2;
            while (start < midpoint | stop - start > 1) {
                midpoint = (start + stop) / 2;
                this.fBuffer.position(midpoint);
                String line = BinarySearchWordnetFile.getLine(this.fBuffer);
                if (midpoint > 0) {
                    line = BinarySearchWordnetFile.getLine(this.fBuffer);
                }
                if (line == null || line.length() == 0) {
                    this.fBuffer.position(start);
                    line = BinarySearchWordnetFile.getLine(this.fBuffer);
                    String newline = BinarySearchWordnetFile.getLine(this.fBuffer);
                    while (newline != null) {
                        line = newline;
                        newline = BinarySearchWordnetFile.getLine(this.fBuffer);
                    }
                    return this.fComparator.compare(line, key) == 0 ? line : null;
                }
                int compare = this.fComparator.compare(line, key);
                if (compare == 0) {
                    return line;
                }
                if (compare > 0) {
                    stop = midpoint;
                    continue;
                }
                start = midpoint;
            }
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return new BinarySearchLineIterator((ByteBuffer)this.fMappedBuffer);
    }

    @Override
    public Iterator<String> iterator(String key) {
        return new BinarySearchLineIterator((ByteBuffer)this.fMappedBuffer, key);
    }

    public class BinarySearchLineIterator
    extends WordnetFile.LineIterator {
        public BinarySearchLineIterator(ByteBuffer file) {
            this(file, null);
        }

        public BinarySearchLineIterator(ByteBuffer buffer, String key) {
            super(BinarySearchWordnetFile.this, buffer, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void findFirstLine(String key) {
            ByteBuffer byteBuffer = this.fMyBuffer;
            synchronized (byteBuffer) {
                int lastOffset = -1;
                int start = 0;
                int stop = this.fMyBuffer.limit();
                int midpoint = -1;
                while (start + 1 < stop) {
                    midpoint = (start + stop) / 2;
                    this.fMyBuffer.position(midpoint);
                    String line = WordnetFile.getLine(this.fMyBuffer);
                    int offset = this.fMyBuffer.position();
                    line = WordnetFile.getLine(this.fMyBuffer);
                    if (line == null) {
                        this.fMyBuffer.position(this.fMyBuffer.limit());
                        return;
                    }
                    int compare = BinarySearchWordnetFile.this.fComparator.compare(line, key);
                    if (compare == 0) {
                        this.next = line;
                        return;
                    }
                    if (compare > 0) {
                        stop = midpoint;
                    } else {
                        start = midpoint;
                    }
                    if (!line.startsWith(key)) continue;
                    lastOffset = offset;
                }
                if (lastOffset > -1) {
                    this.fMyBuffer.position(lastOffset);
                    this.next = WordnetFile.getLine(this.fMyBuffer);
                    return;
                }
                this.fMyBuffer.position(this.fMyBuffer.limit());
            }
        }
    }
}

