/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.story.core.descriptor.IHasName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum POS implements IHasName
{
    UNSPECIFIED("Unspecified"),
    VERB("Verb"),
    ADJECTIVE("Adjective"),
    NOUN("Noun"),
    PREPOSITION("Preposition"),
    OTHER("Other");

    private final String name;

    private POS(String name) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static POS toPOS(ITag tag) {
        if (tag.isVerb()) {
            return VERB;
        }
        if (tag.isNoun() || tag.isProperNoun()) {
            return NOUN;
        }
        if (tag.isAdjective()) {
            return ADJECTIVE;
        }
        if (tag.getTagString().equalsIgnoreCase(PennTag.IN.getTagString())) {
            return PREPOSITION;
        }
        return OTHER;
    }
}

