/* Filename: RefExp.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package edu.mit.discourse.core.rep.refexp;

import java.util.Collection;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class RefExp extends SegmentSet implements IRefExp {
	
	/**
	 * TODO: Write comment
	 *
	 * @param segments
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public RefExp(Collection<? extends ISegment> segments){
		super(segments);
		if(getRep() != TokenRep.getInstance())
			throw new IllegalArgumentException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IHasSegments#getSegments()
	 */
	public IHasPositionSet<ISegment> getSegments() {
		return this;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.SegmentSet#recalculate(edu.mit.story.core.desc.IDesc, edu.mit.story.core.model.IStoryModel)
	 */
	@Override
	public RefExp recalculate(IDesc container, IStoryModel model) {
		ISegmentSet set = (ISegmentSet)super.recalculate(container, model);
		if(set == this)
			return this;
		if(set == null)
			return null;
		return new RefExp(set);
	}

}
