/* Filename: RandCalculator.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Feb 29, 2012
 */
package edu.mit.discourse.core.rep.coref;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.agreement.DoubleResult;
import edu.mit.story.core.agreement.IAgreementCalculator;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.core.agreement.rand.AdjustedRandIndex;
import edu.mit.story.core.agreement.rand.Partitions;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.rep.IRep;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.story.core 1.0.0
 */
public class CorefRandCalculator extends Registered implements IAgreementCalculator {

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.agreement.IAgreementCalculator#getReps()
	 */
	public Set<IRep> getReps() {
		return Collections.singleton(CorefRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.agreement.IAgreementCalculator#calculate(edu.mit.story.core.align.IAlignedStoryModel, java.util.Set)
	 */
	public List<IAgreementResult> calculate(IAlignedStoryModel model, Set<IRep> reps) {
		if(!reps.contains(CorefRep.getInstance()))
			return Collections.emptyList();
		
		IDescMap corefMap = model.get(CorefRep.getInstance());
		final IDescMap refexpMap = model.get(RefExpRep.getInstance());
		
		// unwrap each target coref to get at the refexp set
		Function<IDesc, Set<IDesc>> toRefExpSet = new Function<IDesc, Set<IDesc>>(){
			public Set<IDesc> apply(IDesc input) {
				ICoref coref = (ICoref)input.getData();
				return coref.getReferentialExpressions();
			}
		};
		
		// replace src refexps by their corresponding target refeexp 
		Function<IDesc, Set<IDesc>> toTgtRefExpSet = new Function<IDesc, Set<IDesc>>(){
			public Set<IDesc> apply(IDesc input) {
				ICoref coref = (ICoref)input.getData();
				Set<IDesc> result = new HashSet<IDesc>();
				IDesc tgtD;
				for(IDesc srcD : coref.getReferentialExpressions()){
					tgtD = refexpMap.get(srcD);
					result.add(tgtD == null ? srcD : tgtD);
				}
				return coref.getReferentialExpressions();
			}
		};
		
		Set<Set<IDesc>> srcBundles = new HashSet<Set<IDesc>>(Collections2.transform(corefMap.getSource(), toTgtRefExpSet));
		Set<Set<IDesc>> tgtBundles = new HashSet<Set<IDesc>>(Collections2.transform(corefMap.getTarget(), toRefExpSet));
		Partitions.unify(srcBundles, tgtBundles);
		
		double result = AdjustedRandIndex.getInstance().compute(srcBundles, tgtBundles);
		
		return Collections.<IAgreementResult>singletonList(
				new DoubleResult("Adjusted Rand Index", result, CorefRep.getInstance()));
	}

}
