/* Filename: ModifierController.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 01/10/2009
 */
package nil.ucm.indications2.ui.controllers;

import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.model.IModifierModel;
import nil.ucm.indications2.core.rep.model.ModifierModel;
import edu.mit.story.ui.editor.IStoryEditor;

/** 
 *   Controller implementation for the IModifierModel
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class ModifierController extends IndArgController implements IModifierController {

	public ModifierController(IStoryEditor editor, String annoID) {
		super(new ModifierModel(editor.getStoryModel()), annoID, editor);
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.controllers.SegmentSetController#getModel()
	 */
	@Override
	public IModifierModel getModel() {
		return (IModifierModel)super.getModel();
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications.ui.controllers.IModifierController#load(nil.ucm.indications.core.rep.INucleus)
	 */
	public void load(IModifier mod) {
		if(mod != null) getModel().load(mod);
	}

}
