/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.handlers;

import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.TagSet;
import edu.mit.parsing.core.rep.tag.tagset.handlers.TagHandler;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagModel;
import edu.mit.story.core.descriptor.IRegistered;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.xml.IHasParserHandler;
import edu.mit.story.core.xml.MappedHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsetHandler
extends MappedHandler<ITagset> {
    public static final String XML_TAGSET = "TAGSET";
    private String targetID;
    private ITagset.Scope scope;
    private IRegistered metadata = new Registered(){};
    private List<ITagModel> tagBuilders = new LinkedList<ITagModel>();

    public TagsetHandler() {
        this(null, null, XML_TAGSET);
    }

    public TagsetHandler(XMLReader parser) {
        this(parser, null, XML_TAGSET);
    }

    public TagsetHandler(IHasParserHandler parent) {
        this(parent == null ? null : parent.getParser(), (ContentHandler)parent, XML_TAGSET);
    }

    public TagsetHandler(XMLReader parser, ContentHandler parent, String tag) {
        super(parser, parent, tag);
    }

    protected void clearLocal() {
        this.targetID = null;
        this.scope = null;
        this.metadata = new Registered(){};
        this.tagBuilders = new LinkedList<ITagModel>();
    }

    protected void initHandlerMap(Map<String, ContentHandler> map) {
        map.put("TAG", (ContentHandler)((Object)new TagHandler(this.getParser(), (ContentHandler)((Object)this)){

            public void endTaggedBlock(String uri, String localName, String name) throws SAXException {
                TagsetHandler.this.tagBuilders.add(this.getElement());
            }
        }));
    }

    public void startTaggedBlock(String uri, String localName, String name, Attributes attrs) throws SAXException {
        Version version = Version.parseVersion((String)attrs.getValue("version"));
        if (version.getMajor() != 1 || version.getMinor() != 0 || version.getMicro() != 0 || version.getQualifier().length() != 0) {
            throw new IllegalArgumentException();
        }
        this.metadata.setID(attrs.getValue("id"));
        this.metadata.setName(attrs.getValue("name"));
        this.metadata.setDescription(attrs.getValue("desc"));
        this.targetID = attrs.getValue("target");
        this.scope = ITagset.Scope.valueOf(attrs.getValue("scope").toLowerCase());
        if (this.scope == null) {
            throw new IllegalArgumentException();
        }
    }

    public ITagset getElement() {
        return new TagSet(this.metadata.getID(), this.metadata.getName(), this.metadata.getDescription(), this.targetID, this.scope, this.tagBuilders);
    }
}

