/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.parse;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.parse.IParser;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.IndexedTree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseDefaultFactory
extends AbstractDescFactory2<IndexedTree> {
    private IParser parser;

    public ParseDefaultFactory() {
        super(ParseRep.getInstance(), Arrays.asList(TokenRep.getInstance(), POSRep.getInstance()));
    }

    protected boolean doInit(IStoryModel model) {
        String parserID = (String)this.getConfiguration().get((Object)"parser");
        if (parserID == null) {
            return false;
        }
        this.parser = (IParser)ParsingPlugin.getDefault().getParserManager().create(parserID);
        if (this.parser == null) {
            return false;
        }
        this.parser.init();
        return true;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        IHasPositionSet sentRegions;
        Change tokenChange = event.getChange(TokenRep.getInstance());
        Change posChange = event.getChange(POSRep.getInstance());
        Change sentChange = event.getChange(SentenceRep.getInstance());
        if (tokenChange == null && sentChange == null && posChange == null) {
            return null;
        }
        IHasPositionSet tokenRegions = tokenChange == null ? null : tokenChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet posRegions = posChange == null ? null : posChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet iHasPositionSet = sentRegions = sentChange == null ? null : sentChange.getChanges((IFlag)Flag.DESCS);
        if (!(tokenRegions != null && !tokenRegions.isEmpty() || sentRegions != null && !sentRegions.isEmpty() || posRegions != null && !posRegions.isEmpty())) {
            return null;
        }
        DistinctRegionSet result = new DistinctRegionSet();
        IDescSet sentDescs = event.provider.getData().getDescriptions(SentenceRep.getInstance());
        if (tokenRegions != null) {
            for (IHasPosition region : tokenRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
            }
        }
        if (posRegions != null) {
            for (IHasPosition region : posRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
            }
        }
        if (sentRegions != null) {
            result.addAll((Collection)sentRegions);
        }
        return result;
    }

    protected IHasPositionSet<IndexedTree> calculateData(IHasPosition region, IStoryModel provider) {
        IDescSet sentDescs = provider.getData().getDescriptions(SentenceRep.getInstance()).openSet(region);
        HasPositionSet result = null;
        for (IDesc sentDesc : sentDescs) {
            IndexedTree data = this.parseSentence((IHasPosition)sentDesc, provider);
            if (data == null) continue;
            if (result == null) {
                result = new HasPositionSet();
            }
            result.add((Object)data);
        }
        return result;
    }

    protected IndexedTree parseSentence(IHasPosition sent, IStoryModel provider) {
        IDescSet tokenDescs = provider.getData().getDescriptions(TokenRep.getInstance()).openSet(sent);
        ArrayList<IDesc> tokens = new ArrayList<IDesc>((Collection<IDesc>)tokenDescs);
        ITree tree = this.parser.parse(tokens);
        return tree == null ? null : new IndexedTree(sent, tree);
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new ParseFactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class ParseFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public ParseFactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public ParseFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("parser", ParsingMessages.FACTORY_PARAM_NAME_Parser, ParsingMessages.FACTORY_PARAM_DESC_Parser, (IValidator)new ManagerBackedListValidator(ParsingPlugin.getDefault().getParserManager()), true, "DefaultParserID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

