/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.GenericCounter;
import edu.stanford.nlp.util.EntryValueComparator;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableInteger;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntCounter<E>
implements Serializable,
GenericCounter<E> {
    private Map<E, MutableInteger> map;
    private MapFactory mapFactory;
    private static final Comparator naturalComparator = new NaturalComparator();
    private static final long serialVersionUID = 4L;
    private transient MutableInteger tempMInteger = null;

    public IntCounter() {
        this(MapFactory.HASH_MAP_FACTORY);
    }

    public IntCounter(MapFactory mapFactory) {
        this.mapFactory = mapFactory;
        this.map = mapFactory.newMap();
    }

    public IntCounter(IntCounter<E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public MapFactory getMapFactory() {
        return this.mapFactory;
    }

    public int totalCount() {
        int total = 0;
        for (E key : this.map.keySet()) {
            total += this.getIntCount(key);
        }
        return total;
    }

    @Override
    public double totalDoubleCount() {
        return this.totalCount();
    }

    public int totalCount(Filter filter) {
        int total = 0;
        for (E key : this.map.keySet()) {
            if (!filter.accept(key)) continue;
            total += this.getIntCount(key);
        }
        return total;
    }

    public double totalDoubleCount(Filter filter) {
        return this.totalCount(filter);
    }

    public double averageCount() {
        return (double)this.totalCount() / (double)this.map.size();
    }

    @Override
    public double getCount(E key) {
        return this.getIntCount(key);
    }

    @Override
    public String getCountAsString(E key) {
        return Integer.toString(this.getIntCount(key));
    }

    public int getIntCount(Object key) {
        MutableInteger count = this.map.get(key);
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    public double getNormalizedCount(E key) {
        return this.getCount(key) / (double)this.totalCount();
    }

    public void setCount(E key, int count) {
        if (this.tempMInteger == null) {
            this.tempMInteger = new MutableInteger();
        }
        this.tempMInteger.set(count);
        this.tempMInteger = this.map.put(key, this.tempMInteger);
    }

    @Override
    public void setCount(E key, String s) {
        this.setCount(key, Integer.parseInt(s));
    }

    public void setCounts(Collection<E> keys, int count) {
        Iterator<E> iter = keys.iterator();
        while (iter.hasNext()) {
            this.setCount(iter.next(), count);
        }
    }

    public void incrementCount(E key, int count) {
        if (this.tempMInteger == null) {
            this.tempMInteger = new MutableInteger();
        }
        this.tempMInteger.set(count);
        MutableInteger oldMInteger = this.map.put(key, this.tempMInteger);
        if (oldMInteger != null) {
            this.tempMInteger.set(count + oldMInteger.intValue());
        }
        this.tempMInteger = oldMInteger;
    }

    public void incrementCount(E key) {
        this.incrementCount(key, 1);
    }

    public void incrementCounts(Collection<E> keys, int count) {
        Iterator<E> iter = keys.iterator();
        while (iter.hasNext()) {
            this.incrementCount(iter.next(), count);
        }
    }

    public void incrementCounts(Collection<E> keys) {
        this.incrementCounts(keys, 1);
    }

    public void decrementCount(E key, int count) {
        this.incrementCount(key, -count);
    }

    public void decrementCount(E key) {
        this.decrementCount(key, 1);
    }

    public void decrementCounts(Collection<E> keys, int count) {
        this.incrementCounts(keys, -count);
    }

    public void decrementCounts(Collection<E> keys) {
        this.decrementCounts(keys, 1);
    }

    public void addAll(IntCounter<E> counter) {
        for (E key : counter.keySet()) {
            int count = counter.getIntCount(key);
            this.incrementCount(key, count);
        }
    }

    public void subtractAll(IntCounter<E> counter) {
        for (E key : this.map.keySet()) {
            this.decrementCount(key, counter.getIntCount(key));
        }
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    public Object remove(E key) {
        return this.map.remove(key);
    }

    public void removeAll(Collection<E> c) {
        Iterator<E> iter = c.iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntCounter)) {
            return false;
        }
        IntCounter counter = (IntCounter)o;
        return ((Object)this.map).equals(counter.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(NumberFormat nf, String preAppend, String postAppend, String keyValSeparator, String itemSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append(preAppend);
        ArrayList<E> list = new ArrayList<E>(this.map.keySet());
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            MutableInteger d = this.map.get(key);
            sb.append(key + keyValSeparator);
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(itemSeparator);
        }
        sb.append(postAppend);
        return sb.toString();
    }

    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        ArrayList<E> list = new ArrayList<E>(this.map.keySet());
        try {
            Collections.sort(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            MutableInteger d = this.map.get(key);
            sb.append(key + "=");
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public Object clone() {
        return new IntCounter<E>(this);
    }

    public void removeZeroCounts() {
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            if (this.getCount(iter.next()) != 0.0) continue;
            iter.remove();
        }
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            max = Math.max(max, this.getIntCount(iter.next()));
        }
        return max;
    }

    @Override
    public double doubleMax() {
        return this.max();
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        Iterator<E> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            min = Math.min(min, this.getIntCount(iter.next()));
        }
        return min;
    }

    public E argmax(Comparator tieBreaker) {
        int max = Integer.MIN_VALUE;
        Object argmax = null;
        for (E key : this.keySet()) {
            int count = this.getIntCount(key);
            if (argmax != null && count <= max && (count != max || tieBreaker.compare(key, argmax) >= 0)) continue;
            max = count;
            argmax = key;
        }
        return (E)argmax;
    }

    public E argmax() {
        return this.argmax(naturalComparator);
    }

    public E argmin(Comparator tieBreaker) {
        int min = Integer.MAX_VALUE;
        Object argmin = null;
        for (E key : this.map.keySet()) {
            int count = this.getIntCount(key);
            if (argmin != null && count >= min && (count != min || tieBreaker.compare(key, argmin) >= 0)) continue;
            min = count;
            argmin = key;
        }
        return (E)argmin;
    }

    public E argmin() {
        return this.argmin(naturalComparator);
    }

    public Set keysAbove(int countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) < countThreshold) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set keysBelow(int countThreshold) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) > countThreshold) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set keysAt(int count) {
        HashSet<E> keys = new HashSet<E>();
        for (E key : this.map.keySet()) {
            if (this.getIntCount(key) != count) continue;
            keys.add(key);
        }
        return keys;
    }

    public Comparator comparator(boolean ascending) {
        return new EntryValueComparator(this.map, ascending);
    }

    public Comparator comparator(boolean ascending, boolean useMagnitude) {
        return new EntryValueComparator(this.map, ascending, useMagnitude);
    }

    @Override
    public Comparator comparator() {
        return this.comparator(true);
    }

    private static class NaturalComparator
    implements Comparator {
        private NaturalComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    }
}

