/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.wizards.page;

import edu.mit.discourse.core.compare.DiscourseFScoreCalculator;
import edu.mit.discourse.core.compare.IScoredElement;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.content.ComparisonTreeContentProvider;
import edu.mit.discourse.ui.label.ComparisonTreeLabelProvider;
import edu.mit.discourse.ui.wizards.page.SpecifyStoriesPage;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.XMLBackedStoryModel;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.util.Debug;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.ops.CreateFileOperation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ComparisonResultsPage
extends WizardPage {
    Label fileLeftLabel;
    Label fileRightLabel;
    Label summaryLabel;
    Button exportButton;
    TreeViewer treeViewer;
    public static final String NAME = StringUtils.getClassName(SpecifyStoriesPage.class);
    protected XMLBackedStoryModel leftAnnotation;
    protected XMLBackedStoryModel rightAnnotation;
    public IScoredElement comparisonResults;
    private IPath leftFile;
    private IPath rightFile;

    public ComparisonResultsPage() {
        super(NAME);
        this.setTitle(StoryUIMessages.WIZARD_PAGE_ComparisonResults_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_ComparisonResults_description);
    }

    public void createControl(Composite parent) {
        Composite topGroup = new Composite(parent, 0);
        this.setControl((Control)topGroup);
        topGroup.setLayout((Layout)new GridLayout());
        this.fileLeftLabel = new Label(topGroup, 16384);
        this.fileRightLabel = new Label(topGroup, 16384);
        this.summaryLabel = new Label(topGroup, 16384);
        this.summaryLabel.setAlignment(131072);
        this.fileLeftLabel.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_leftSource_label);
        this.fileRightLabel.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_rightSource_label);
        this.summaryLabel.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_score_label_error);
        GridData fileLabelGridData = new GridData(768);
        fileLabelGridData.heightHint = 30;
        this.fileLeftLabel.setLayoutData((Object)fileLabelGridData);
        this.fileRightLabel.setLayoutData((Object)fileLabelGridData);
        this.treeViewer = new TreeViewer(topGroup);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(400, 1000));
        this.exportButton = new Button(topGroup, 0);
        this.exportButton.setText("Export...");
        final FileDialog fd = new FileDialog(topGroup.getShell(), 8192);
        this.exportButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                String selected = fd.open();
                String[] extensions = new String[]{"*.csv"};
                fd.setFilterExtensions(extensions);
                fd.setText("Export Story Comparison as CSV...");
                if (selected != null) {
                    ComparisonResultsPage.this.exportText(new File(selected));
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Tree tree = this.treeViewer.getTree();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        LinkedList<String> columnHeadings = new LinkedList<String>();
        TreeColumn typeColumn = new TreeColumn(tree, 16384);
        typeColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_type);
        typeColumn.setWidth(120);
        columnHeadings.add("Type");
        TreeColumn scoreColumn = new TreeColumn(tree, 16384);
        scoreColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_score);
        scoreColumn.setWidth(120);
        columnHeadings.add("Score");
        TreeColumn leftIDColumn = new TreeColumn(tree, 16384);
        leftIDColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Lid);
        leftIDColumn.setWidth(45);
        columnHeadings.add("L-ID");
        TreeColumn rightIDColumn = new TreeColumn(tree, 16384);
        rightIDColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Rid);
        rightIDColumn.setWidth(45);
        columnHeadings.add("R-ID");
        TreeColumn leftTextColumn = new TreeColumn(tree, 16384);
        leftTextColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Ltext);
        leftTextColumn.setWidth(120);
        columnHeadings.add("L-Text");
        TreeColumn rightTextColumn = new TreeColumn(tree, 16384);
        rightTextColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Rtext);
        rightTextColumn.setWidth(120);
        columnHeadings.add("R-Text");
        TreeColumn leftSizeColumn = new TreeColumn(tree, 0x1000000);
        leftSizeColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Lcomponents);
        leftSizeColumn.setWidth(120);
        columnHeadings.add("L-Components");
        TreeColumn rightSizeColumn = new TreeColumn(tree, 0x1000000);
        rightSizeColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_Rcomponents);
        rightSizeColumn.setWidth(120);
        columnHeadings.add("R-Components");
        TreeColumn commonComponentsColumn = new TreeColumn(tree, 0x1000000);
        commonComponentsColumn.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_columnHeading_common);
        commonComponentsColumn.setWidth(120);
        columnHeadings.add("Common");
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.setResizable(true);
            column.setMoveable(false);
            ++n2;
        }
        this.treeViewer.setContentProvider((IContentProvider)new ComparisonTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ComparisonTreeLabelProvider(columnHeadings));
    }

    public boolean setStoryPaths(IPath leftFile, IPath rightFile) {
        boolean valid = true;
        if (leftFile != null && rightFile != null) {
            if (leftFile.equals((Object)this.leftFile) && rightFile.equals((Object)this.rightFile)) {
                return true;
            }
            this.leftFile = leftFile;
            this.rightFile = rightFile;
            this.fileLeftLabel.setText(String.valueOf(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_leftSource_label) + leftFile.toPortableString());
            this.fileRightLabel.setText(String.valueOf(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_rightSource_label) + rightFile.toPortableString());
            StringBuilder builder = new StringBuilder();
            StringUtils.loadStreamIntoBuffer((Appendable)builder, (InputStream)CreateFileOperation.getContent((IPath)leftFile));
            String xmlLeft = builder.toString();
            builder = new StringBuilder();
            StringUtils.loadStreamIntoBuffer((Appendable)builder, (InputStream)CreateFileOperation.getContent((IPath)rightFile));
            String xmlRight = builder.toString();
            XMLBackedStoryModel left = new XMLBackedStoryModel(CharRep.getInstance());
            XMLBackedStoryModel right = new XMLBackedStoryModel(CharRep.getInstance());
            left.setXML(xmlLeft);
            right.setXML(xmlRight);
            if (valid) {
                this.leftAnnotation = left;
                this.rightAnnotation = right;
                this.calculateResults();
                if (this.comparisonResults != null) {
                    this.summaryLabel.setText(String.valueOf(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_score_label) + String.valueOf(this.comparisonResults.getScore()));
                } else {
                    this.summaryLabel.setText(DiscourseUIMessages.WIZARD_PAGE_ComparisonResultsPage_score_label_error);
                }
                this.summaryLabel.setText(String.valueOf(this.comparisonResults != null ? Double.valueOf(this.comparisonResults.getScore()) : null));
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public boolean calculateResults() {
        DiscourseFScoreCalculator calc = DiscourseFScoreCalculator.getInstance();
        try {
            this.comparisonResults = calc.scoreStories((StoryModel)this.leftAnnotation, (StoryModel)this.rightAnnotation);
            this.treeViewer.setInput((Object)this.comparisonResults);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setErrorMessage(DiscourseUIMessages.MSG_CalculationFailed);
            return false;
        }
    }

    public void exportText(File tabFile) {
        StringBuilder sb = new StringBuilder();
        Tree tree = this.treeViewer.getTree();
        this.treeViewer.expandAll();
        LinkedList<String> columnHeadings = new LinkedList<String>();
        int i = 0;
        while (i < tree.getColumnCount()) {
            columnHeadings.add(tree.getColumn(i).getText());
            ++i;
        }
        Iterator itr = columnHeadings.iterator();
        while (itr.hasNext()) {
            sb.append((String)itr.next());
            if (!itr.hasNext()) continue;
            sb.append('\t');
        }
        LinkedList<TreeItem> agenda = new LinkedList<TreeItem>();
        agenda.add(0, tree.getTopItem());
        ArrayList<String> itemData = new ArrayList<String>(tree.getColumnCount());
        while (!agenda.isEmpty()) {
            itemData.clear();
            TreeItem currentItem = (TreeItem)agenda.remove(0);
            int i2 = 0;
            while (i2 < tree.getColumnCount()) {
                if (ComparisonResultsPage.isNumeric(currentItem.getText(i2))) {
                    itemData.add(i2, currentItem.getText(i2));
                } else {
                    itemData.add(i2, "\"" + currentItem.getText(i2) + "\"");
                }
                ++i2;
            }
            itr = itemData.iterator();
            sb.append("\r\n");
            while (itr.hasNext()) {
                sb.append((String)itr.next());
                if (!itr.hasNext()) continue;
                sb.append('\t');
            }
            TreeItem[] treeItemArray = currentItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                agenda.add(0, child);
                ++n2;
            }
        }
        BufferedWriter output = null;
        try {
            if (!tabFile.createNewFile()) {
                Debug.out((String)"File alrady exists");
            }
            output = new BufferedWriter(new FileWriter(tabFile));
            output.write(sb.toString());
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNumeric(String s) throws NullPointerException {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

