/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.parsing.ui.controllers.SegmentController;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.model.ITimeLinkModel;
import edu.mit.semantics.core.rep.timelink.model.TimeLinkModel;
import edu.mit.semantics.ui.controllers.ITimeLinkController;
import edu.mit.semantics.ui.label.EventLabelProvider;
import edu.mit.semantics.ui.label.Timex3LabelProvider;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.AbstractSelectionDialogCaptureStrategy;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.CompositeLabelProvider;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLinkController
implements ITimeLinkController {
    private final IStoryEditor editor;
    private final ITimeLinkModel linkModel;
    private final IDescController<IDescModel> srcControl;
    private final IDescController<IDescModel> relControl;
    private final ISegmentController sigControl;

    public TimeLinkController(IStoryEditor editor) {
        this("edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2", "edu.mit.story.ui.annotation.target3", editor);
    }

    public TimeLinkController(String srcAnno, String relAnno, String sigAnno, IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.linkModel = new TimeLinkModel((IStoryModel)editor.getStoryModel());
        LinkSelectionDialogCaptureStrategy strategy = new LinkSelectionDialogCaptureStrategy(editor, this.linkModel.getSourceModel());
        this.srcControl = new DescController(this.linkModel.getSourceModel(), srcAnno, editor, (ICaptureStrategy)strategy);
        strategy = new LinkSelectionDialogCaptureStrategy(editor, this.linkModel.getRelatedModel());
        this.relControl = new DescController(this.linkModel.getRelatedModel(), srcAnno, editor, (ICaptureStrategy)strategy);
        this.sigControl = new SegmentController(this.linkModel.getSignalModel(), sigAnno, editor);
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public ITimeLinkModel getLinkModel() {
        return this.linkModel;
    }

    @Override
    public IDescController<IDescModel> getSourceController() {
        return this.srcControl;
    }

    @Override
    public IDescController<IDescModel> getRelatedController() {
        return this.relControl;
    }

    @Override
    public ISegmentController getSignalController() {
        return this.sigControl;
    }

    @Override
    public void setRelatedType(IRelType type) {
        this.linkModel.setRelationType(type);
    }

    @Override
    public void load(IDesc desc) {
        this.linkModel.setLoaded(desc);
    }

    @Override
    public void commit() {
        ITimeLink l = this.linkModel.toLink();
        Timing timing = new Timing(this.linkModel.getStart(), "user");
        IHasPosition p = l.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)TimeLinkRep.getInstance(), (IHasPosition)p, (IData)l, (ITiming)timing, (IDesc)this.linkModel.getLoaded());
        this.clear();
    }

    @Override
    public void clear() {
        this.linkModel.clear();
    }

    public void dispose() {
        this.linkModel.dispose();
        this.srcControl.dispose();
        this.relControl.dispose();
        this.sigControl.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkSelectionDialogCaptureStrategy
    extends AbstractSelectionDialogCaptureStrategy {
        private final IDescModel model;
        private ILabelProvider lp;

        public LinkSelectionDialogCaptureStrategy(IStoryEditor editor, IDescModel model) {
            super(editor);
            if (model == null) {
                throw new NullPointerException();
            }
            this.model = model;
        }

        protected ILabelProvider getLabelProvider() {
            if (this.lp == null) {
                this.lp = new CompositeLabelProvider(new ILabelProvider[]{new EventLabelProvider(this.getStoryEditor()), new Timex3LabelProvider(this.getStoryEditor())});
            }
            return this.lp;
        }

        protected Set<IRep> getReps() {
            return this.model.getReps();
        }
    }
}

