/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.MementoUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.progress.UIJob;

class ElementCompareRequest
extends MementoUpdate
implements IElementCompareRequest {
    private boolean fEqual;
    private final int fModelIndex;
    private ModelDelta fDelta;
    private boolean fKnowsHasChildren;
    private boolean fKnowsChildCount;

    public ElementCompareRequest(ModelContentProvider provider, Object viewerInput, Object element, TreePath elementPath, IMemento memento, ModelDelta delta, int modelIndex, boolean hasChildren, boolean knowsChildCount) {
        super(provider, viewerInput, provider.getPresentationContext(), element, elementPath, memento);
        this.fProvider = provider;
        this.fDelta = delta;
        this.fModelIndex = modelIndex;
        this.fKnowsHasChildren = hasChildren;
        this.fKnowsChildCount = knowsChildCount;
    }

    public void setEqual(boolean equal) {
        this.fEqual = equal;
    }

    public void done() {
        UIJob job = new UIJob("restore delta"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!ElementCompareRequest.this.isCanceled()) {
                    ElementCompareRequest.this.fProvider.compareFinished(ElementCompareRequest.this, ElementCompareRequest.this.fDelta);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    boolean isEqual() {
        return this.fEqual;
    }

    ModelDelta getDelta() {
        return this.fDelta;
    }

    int getModelIndex() {
        return this.fModelIndex;
    }

    void setKnowsHasChildren(boolean hasChildren) {
        this.fKnowsHasChildren = hasChildren;
    }

    boolean knowsHasChildren() {
        return this.fKnowsHasChildren;
    }

    void setKnowsChildCount(boolean childCount) {
        this.fKnowsChildCount = childCount;
    }

    boolean knowChildCount() {
        return this.fKnowsChildCount;
    }
}

