/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui;

import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.StoryUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class WorkbenchUtils
implements IUtilityClass {
    public static IViewPart openView(IWorkbenchWindow window, String viewId) {
        IViewPart view = window.getActivePage().findView(viewId);
        if (view == null) {
            try {
                view = window.getActivePage().showView(viewId, null, 3);
            }
            catch (PartInitException partInitException) {
                return null;
            }
        }
        window.getActivePage().activate((IWorkbenchPart)view);
        return view;
    }

    public static IFile convertToFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static void openEditor(IFile file, IWorkbenchWindow dw) {
        IWorkbenchPage page;
        if (dw != null && (page = dw.getActivePage()) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                Status status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)dw.getShell(), (String)"Error opening editor.", (String)e.getMessage(), (IStatus)status);
            }
        }
    }

    public static ISchedulingRule getSchedulingRule(IFile file) {
        IWorkspaceRoot result = null;
        IFile child = file;
        IContainer parent = file.getParent();
        while (parent != null) {
            if (parent.exists()) {
                result = child.getWorkspace().getRuleFactory().createRule((IResource)child);
                break;
            }
            child = parent;
            parent = parent.getParent();
        }
        return result != null ? result : child.getWorkspace().getRoot();
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static void runInUIThread(Runnable runnable) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }
}

