/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.GenerateChangeLogDialog;

public class GenerateChangeLogAction
extends Action {
    private ISelectionProvider selectionProvider;

    public GenerateChangeLogAction(ISelectionProvider selectionProvider) {
        super(Policy.bind("HistoryView.generateChangeLog"));
        this.selectionProvider = selectionProvider;
    }

    public void run() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)GenerateChangeLogAction.this.selectionProvider.getSelection();
                Iterator iter = selection.iterator();
                try {
                    GenerateChangeLogDialog dialog = new GenerateChangeLogDialog(Display.getDefault().getActiveShell());
                    if (dialog.open() == 1) {
                        return;
                    }
                    if (dialog.getOutput() == 1) {
                        File file = dialog.getFile();
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                        while (iter.hasNext()) {
                            Object object = iter.next();
                            if (!(object instanceof LogEntry)) continue;
                            LogEntry logEntry = (LogEntry)object;
                            if (dialog.getFormat() == 2) {
                                writer.write(logEntry.getGnuLog());
                                continue;
                            }
                            writer.write(logEntry.getChangeLog(dialog.getFormat() == 1));
                        }
                        writer.close();
                    } else {
                        StringBuffer changeLog = new StringBuffer();
                        while (iter.hasNext()) {
                            Object object = iter.next();
                            if (!(object instanceof LogEntry)) continue;
                            LogEntry logEntry = (LogEntry)object;
                            if (dialog.getFormat() == 2) {
                                changeLog.append(logEntry.getGnuLog());
                                continue;
                            }
                            changeLog.append(logEntry.getChangeLog(dialog.getFormat() == 1));
                        }
                        TextTransfer plainTextTransfer = TextTransfer.getInstance();
                        Clipboard clipboard = new Clipboard(Display.getDefault());
                        clipboard.setContents((Object[])new String[]{changeLog.toString().trim()}, new Transfer[]{plainTextTransfer});
                        clipboard.dispose();
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind("HistoryView.generateChangeLog"), (String)e.getMessage());
                }
            }
        });
    }
}

