/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;

public abstract class ArtifactRequest
implements IArtifactRequest {
    private static final Status DEFAULT_STATUS = new Status(4, "org.eclipse.equinox.p2.artifact.repository", "default");
    protected IArtifactKey artifact;
    protected String resolvedKey;
    protected IArtifactRepository source;
    protected IStatus result = DEFAULT_STATUS;
    protected IArtifactDescriptor descriptor;

    public ArtifactRequest(IArtifactKey key) {
        this.artifact = key;
    }

    public IArtifactKey getArtifactKey() {
        return this.artifact;
    }

    public IArtifactDescriptor getArtifactDescriptor() {
        return this.descriptor;
    }

    public IStatus getResult() {
        if (this.result == DEFAULT_STATUS) {
            return new Status(4, "org.eclipse.equinox.p2.artifact.repository", "No repository found containing: " + this.getArtifactKey().toString());
        }
        return this.result;
    }

    protected IArtifactRepository getSourceRepository() {
        return this.source;
    }

    public abstract void perform(IProgressMonitor var1);

    public void setDescriptor(IArtifactDescriptor value) {
        if (!value.getArtifactKey().equals(this.artifact)) {
            throw new IllegalArgumentException("Descriptor's key must match the request's key");
        }
        this.descriptor = value;
        if (this.artifact == null) {
            this.artifact = value.getArtifactKey();
        }
    }

    protected void setResult(IStatus value) {
        this.result = value;
    }

    public void setSourceRepository(IArtifactRepository value) {
        this.source = value;
    }
}

