/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDescriptionsChange
extends AbstractModelChange {
    public final List<Long> removeList;

    public RemoveDescriptionsChange(IDesc desc) {
        super(StoryMessages.CHANGE_NAME_RemoveDescriptions);
        this.removeList = Collections.singletonList(desc.getID());
    }

    public RemoveDescriptionsChange(Collection<? extends IDesc> descs) {
        super(StoryMessages.CHANGE_NAME_RemoveDescriptions);
        if (descs.isEmpty()) {
            this.removeList = Collections.emptyList();
        } else {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>(descs.size());
            for (IDesc iDesc : descs) {
                ids.add(iDesc.getID());
            }
            this.removeList = Collections.unmodifiableList(new ArrayList(ids));
        }
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        ArrayList<IDesc> removed = new ArrayList<IDesc>(this.removeList.size());
        IStoryData data = model.getData();
        for (Long id : this.removeList) {
            IDesc desc = data.getDescription(id);
            if (!data.remove(desc)) continue;
            removed.add(desc);
            data.getMetadata().addAllDescs(desc.getMetaData());
        }
        if (removed.isEmpty()) {
            return null;
        }
        Collections.reverse(removed);
        AddDescriptionsChange undo = new AddDescriptionsChange(removed);
        DescMultiSet multiSet = new DescMultiSet(removed);
        TreeMap<IRep, Change> changeMap = new TreeMap<IRep, Change>();
        Iterator<IDescSet> i = multiSet.descSetIterator();
        while (i.hasNext()) {
            IDescSet descSet = i.next();
            changeMap.put(descSet.getRep(), new Change(Flag.DESC_REMOVED, descSet));
        }
        return new StoryChangeEvent(source, model, changeMap, this, undo);
    }
}

