/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.hovers;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class WordHover
extends StoryTextHover {
    public WordHover() {
        super(TokenRep.getInstance());
    }

    public String getHoverInfo(IStoryModel model, int hoverOffset, IHasPosition selection) {
        try {
            return this.getHoverInfoUncaught(model, hoverOffset, selection);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected String getHoverInfoUncaught(IStoryModel model, int hoverOffset, IHasPosition selection) {
        if (!model.supports(TokenRep.getInstance())) {
            return null;
        }
        HasPositionSet words = new HasPositionSet();
        SimplePosition hp = new SimplePosition(hoverOffset, 0);
        IDescSet ds = DescUtils.getDescriptions((IHasPosition)hp, (IDescSet)model.getData().getDescriptions(TokenRep.getInstance()));
        words.addAll((Collection)ds);
        if (model.supports(CollocRep.getInstance())) {
            ds = DescUtils.getDescriptions((IHasPosition)hp, (IDescSet)model.getData().getDescriptions(CollocRep.getInstance()));
            words.addAll((Collection)ds);
        }
        boolean pos = model.supports(POSRep.getInstance());
        boolean stem = model.supports(StemRep.getInstance());
        StringBuilder sb = new StringBuilder();
        IDesc word = null;
        Iterator i = words.iterator();
        while (i.hasNext()) {
            if (word != null) {
                sb.append("\n\n");
            }
            word = (IDesc)i.next();
            sb.append(this.getTextLine(word));
            if (pos) {
                sb.append('\n');
                sb.append(this.getPOSLine(word, model));
            }
            if (!stem) continue;
            sb.append('\n');
            sb.append(this.getStemLine(word, model));
        }
        return sb.toString();
    }

    protected String getTextLine(IDesc word) {
        IBaseToken token = (IBaseToken)word.getData();
        return "WORD : " + token.getSurface();
    }

    protected String getPOSLine(IDesc word, IStoryModel model) {
        IDescSet posDescs = model.getData().getDescriptions(POSRep.getInstance());
        IDescSet matches = posDescs.matchSet((IHasPosition)word);
        ArrayList<IDesc> actual = new ArrayList<IDesc>(matches.size());
        for (IDesc pos : matches) {
            IPosTag tag = (IPosTag)pos.getData();
            if (tag.getWord() != word) continue;
            actual.add(pos);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("POS     : ");
        if (actual.isEmpty()) {
            sb.append("none");
        } else {
            Iterator i = actual.iterator();
            while (i.hasNext()) {
                this.appendPOS((IPosTag)((IDesc)i.next()).getData(), sb);
                if (!i.hasNext()) continue;
                sb.append(", or ");
            }
            if (actual.size() > 1) {
                sb.append(" (ambiguous)");
            }
        }
        return sb.toString();
    }

    protected void appendPOS(IPosTag tag, StringBuilder sb) {
        if (tag.isAuxiliary()) {
            sb.append("Auxiliary ");
        }
        sb.append(tag.getTag().getName());
        sb.append(" (");
        sb.append(tag.getTag().getTagString());
        if (tag.isAuxiliary()) {
            sb.append("-AUX");
        }
        sb.append(')');
    }

    protected String getStemLine(IDesc word, IStoryModel model) {
        IStem stem;
        IDescSet stemDescs = model.getData().getDescriptions(StemRep.getInstance());
        IDescSet matches = stemDescs.matchSet((IHasPosition)word);
        ArrayList<IDesc> actual = new ArrayList<IDesc>(matches.size());
        for (IDesc stemDesc : matches) {
            stem = (IStem)stemDesc.getData();
            if (stem.getWord() != word) continue;
            actual.add(stemDesc);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("STEM   : ");
        if (actual.isEmpty()) {
            sb.append("(same as surface form)");
        } else {
            Iterator i = actual.iterator();
            while (i.hasNext()) {
                stem = (IStem)((IDesc)i.next()).getData();
                sb.append(stem.getStem());
                if (!i.hasNext()) continue;
                sb.append(", or ");
            }
            if (actual.size() > 1) {
                sb.append(" (ambiguous)");
            }
        }
        return sb.toString();
    }
}

