/* Filename: AllVerbsTaggedRule.java
 * Author: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Nov 4, 2009
 */
package edu.mit.discourse.core.rep.refexp.rules;

import java.util.LinkedList;
import java.util.List;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refexp.problems.IdenticalRefexpsProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.semantics.core 1.0.0
 */
public class UniqueRefexpsRule extends AbstractBuildRule {

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since edu.mit.semantics.core 1.0.0
	 */
	public UniqueRefexpsRule() {
		super(RefExpRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		List<IDescSet> problems = new LinkedList<IDescSet>();
		
		// map all referring expressions to their uses
		IDescSet identical = new DescSet(RefExpRep.getInstance());
		IDescSet last = null, curr;
		for(IDesc refexpDesc : model.getData().getDescriptions(RefExpRep.getInstance())){
			curr = Segment.extractSegmentDescriptions((IRefExp)refexpDesc.getData());
			if(!curr.equals(last)){
				if(identical.size() > 1){
					problems.add(identical);
					identical = new DescSet(RefExpRep.getInstance());
				} else {
					identical.clear();
				}
			}
			identical.add(refexpDesc);
			last = curr;
			
		}
		if(identical.size() > 1)
			problems.add(identical);
		if(problems.isEmpty())
			return null;
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		for(IDescSet group : problems)
			result.add(new IdenticalRefexpsProblem(group, getID()));
		return result;
	}

}
