/* Filename: OverallAgreeResult.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 12, 2010
 */
package nil.ucm.indications2.ui.agreement;

import org.eclipse.core.resources.IResource;

import edu.mit.story.core.measure.PairResult;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class OverallAgreeResult extends PairResult implements
		IOverallAgreeResult {

	private final double tokensF;
	private final double refsF;
	private final double constsF;
	private final double copularK;
	private final double constsK;
	private final double constsFuncK;
	private final double refsFuncK;
	
	/**
	 * TODO: Write comment
	 *
	 * @param one
	 * @param two
	 * @param message
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public OverallAgreeResult(IResource one, IResource two, String message,
							  double tokensF, double refsF, double constsF,
							  double copularK, double constsK, double constsFuncK, double refsFuncK) {
		super(one, two, message);
		this.tokensF = checkF(tokensF);
		this.refsF = checkF(refsF);
		this.constsF = checkF(constsF);
		this.copularK = checkKappa(copularK);
		this.constsK = checkKappa(constsK);
		this.constsFuncK = checkKappa(constsFuncK);
		this.refsFuncK = checkKappa(refsFuncK);
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getTokensFMeasure()
	 */
	public double getTokensFMeasure() {
		return tokensF;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getReferencesFMeasure()
	 */
	public double getReferencesFMeasure() {
		return refsF;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getConstituentsFMeasure()
	 */
	public double getConstituentsFMeasure() {
		return constsF;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getCopularKappa()
	 */
	public double getCopularKappa() {
		return copularK;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getConstituentsKappa()
	 */
	public double getConstituentsKappa() {
		return constsK;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getFunctionKappa()
	 */
	public double getFunctionKappa() {
		return constsFuncK;
	}
	
	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.agreement.IOverallAgreeResult#getFunctionKappa()
	 */
	public double getReferencesKappa() {
		return refsFuncK;
	}

	public String toString(boolean incRes) {
		StringBuilder sb = new StringBuilder();
		if(incRes){
			sb.append(getTarget().getName()).append('\t');
			sb.append(getSource().getName()).append('\t');
		}
		sb.append(Double.toString(tokensF)).append('\t');
		sb.append(Double.toString(refsF)).append('\t');
		sb.append(Double.toString(constsF)).append('\t');
		sb.append(Double.toString(copularK)).append('\t');
		sb.append(Double.toString(constsK)).append('\t');
		sb.append(Double.toString(constsFuncK)).append('\t');
		sb.append(Double.toString(refsFuncK)).append('\t');
		sb.append(getMessage()).append('\t');
		return sb.toString();
	}

	public static String getHeaders(boolean incRes){
		StringBuilder sb = new StringBuilder();
		if(incRes){
			sb.append("Resource One").append('\t');
			sb.append("Resource Two").append('\t');
		}
		sb.append("Tokens F-Measure").append('\t');
		sb.append("References F-Measure").append('\t');
		sb.append("Constituents F-Measure").append('\t');
		sb.append("Copular Kappa").append('\t');
		sb.append("Constituents Kappa").append('\t');
		sb.append("Functions Kappa").append('\t');
		sb.append("References Kappa").append('\t');
		
		return sb.toString();
		
	}
	
	public static class OverallAgreeBuilder {
		
		public double tokensF;
		public double refsF;
		public double constsF;
		public double copularK;
		public double constsK;
		public double constsFuncK;
		public double refsFuncK;
		
		public OverallAgreeResult toResult(IResource one, IResource two, String message){
			return new OverallAgreeResult(one, two, message, tokensF, refsF, constsF, copularK, constsK, constsFuncK, refsFuncK);
		}
		
	}

}
