/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.handlers;

import edu.mit.discourse.core.rep.coref.Coref;
import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.changes.MoveRefexpModelChange;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.dialogs.CorefSelectionDialog;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveRefExpHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "edu.mit.discourse.ui.commands.moveRefexp";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDesc target;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List descs = SelectionUtils.extractAll((ISelection)currentSelection, IDesc.class);
        if (descs.isEmpty()) {
            return null;
        }
        for (IDesc d : descs) {
            if (RefExpRep.getInstance().isType((IHasRep)d)) continue;
            return null;
        }
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Object result = CorefSelectionDialog.open(editor, null, null, (IHasPosition)(target = descs.size() == 1 ? (IDesc)descs.get(0) : null));
        if (result == null) {
            return null;
        }
        if (result instanceof IDesc) {
            MoveRefexpModelChange change;
            IDesc tgtCoref = (IDesc)result;
            if (target != null) {
                change = new MoveRefexpModelChange(tgtCoref, target);
            } else {
                ArrayList<MoveRefexpModelChange> changes = new ArrayList<MoveRefexpModelChange>(descs.size());
                for (IDesc refexp : descs) {
                    changes.add(new MoveRefexpModelChange(tgtCoref, refexp));
                }
                change = new CompositeModelChange(changes);
            }
            editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
            return null;
        }
        if (result instanceof String) {
            String name = (String)result;
            Coref coref = new Coref(name, (Collection)descs);
            Timing editTime = new Timing("user", true);
            ChangeUtils.createModelEdit((Object)((Object)this), (IMutableStoryModel)editor.getStoryModel(), (IRep)CorefRep.getInstance(), (IHasPosition)coref.calculatePosition(), (IData)coref, (ITiming)editTime, null);
        }
        return null;
    }
}

