/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions.delegates;

import edu.mit.discourse.core.rep.relation.RelationRep;
import edu.mit.discourse.ui.relation.LexicalMarkerHighlighter;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

public class ShowLexMarkersDelegate
extends AbstractDelegate {
    IStoryEditor editor;
    LexicalMarkerHighlighter highlighter;

    public void run(IAction action) {
        if (this.highlighter != null) {
            this.highlighter.setEnabled(action.isChecked());
        }
    }

    protected void setActivePart(IWorkbenchPart activePart) {
        IStoryEditor newEditor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
        if (newEditor == this.editor) {
            return;
        }
        this.editor = null;
        this.highlighter = null;
        if (newEditor != null) {
            this.editor = newEditor;
            this.highlighter = LexicalMarkerHighlighter.getHighlighter(this.editor);
        }
    }

    protected void updateAction(IAction action) {
        boolean enabled = this.editor != null && this.editor.getStoryModel().supports(RelationRep.getInstance());
        action.setEnabled(enabled);
        action.setChecked(this.highlighter != null && this.highlighter.isEnabled());
    }
}

