/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.WordnetFile;
import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.item.IVersion;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements IVersion {
    private static final Map<Integer, Version> versionCache = new HashMap<Integer, Version>();
    public static final Version ver16 = Version.createVersion(1, 6, 0);
    public static final Version ver17 = Version.createVersion(1, 7, 0);
    public static final Version ver171 = Version.createVersion(1, 7, 1);
    public static final Version ver20 = Version.createVersion(2, 0, 0);
    public static final Version ver21 = Version.createVersion(2, 1, 0);
    public static final Version ver30 = Version.createVersion(3, 0, 0);
    public static List<Version> versions = Arrays.asList(ver16, ver17, ver171, ver20, ver21, ver30);
    public static final int versionOffset = 803;
    private final int major;
    private final int minor;
    private final int bugfix;
    private String toString;
    private static final String point = ".";
    private static final Pattern periodPattern = Pattern.compile("\\Q.\\E");
    private static final String wordnetStr = "WordNet";
    private static final String copyrightStr = "Copyright";
    private static final Pattern versionPattern = Pattern.compile("WordNet\\s+\\d+\\Q.\\E\\d+(\\Q.\\E\\d+)?\\s+Copyright");

    protected Version(int major, int minor, int bugfix) {
        Version.checkVersionNumber(major, minor, bugfix);
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getBugfixVersion() {
        return this.bugfix;
    }

    public int hashCode() {
        return Version.hashCode(this.major, this.minor, this.bugfix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IVersion)) {
            return false;
        }
        IVersion other = (IVersion)obj;
        if (this.bugfix != other.getBugfixVersion()) {
            return false;
        }
        if (this.major != other.getMajorVersion()) {
            return false;
        }
        return this.minor == other.getMinorVersion();
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Version.makeVersionString(this.major, this.minor, this.bugfix);
        }
        return this.toString;
    }

    public static void checkVersionNumber(int major, int minor, int bugfix) {
        if (Version.isIllegalVersionNumber(major, minor, bugfix)) {
            throw new IllegalArgumentException("Illegal version number: " + Version.makeVersionString(major, minor, bugfix));
        }
    }

    public static boolean isIllegalVersionNumber(int major, int minor, int bugfix) {
        return major < 0 || minor < 0 || bugfix < 0;
    }

    public static Version createVersion(int major, int minor, int bugfix) {
        Version.checkVersionNumber(major, minor, bugfix);
        int hash = Version.hashCode(major, minor, bugfix);
        Version version = versionCache.get(hash);
        if (version == null) {
            version = new Version(major, minor, bugfix);
            versionCache.put(version.hashCode(), version);
        }
        return version;
    }

    public static String makeVersionString(int major, int minor, int bugfix) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(major));
        sb.append(point);
        sb.append(Integer.toString(minor));
        if (bugfix > 0) {
            sb.append(point);
            sb.append(Integer.toString(bugfix));
        }
        return sb.toString();
    }

    public static int hashCode(int major, int minor, int bugfix) {
        int prime = 31;
        int result = 1;
        result = 31 * result + bugfix;
        result = 31 * result + major;
        result = 31 * result + minor;
        return result;
    }

    public static Version extractVersion(IContentType<?> type, ByteBuffer buffer) {
        char c;
        if (!type.getDataType().hasVersion()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 803; i < buffer.limit() && !Character.isWhitespace(c = (char)buffer.get(i)); ++i) {
            sb.append(c);
        }
        Version version = Version.parseVersion(sb);
        if (version != null) {
            return version;
        }
        ICommentDetector cd = type.getLineComparator().getCommentDetector();
        if (cd == null) {
            return null;
        }
        int origPos = buffer.position();
        String line = null;
        while (buffer.position() < buffer.limit()) {
            line = WordnetFile.getLine(buffer);
            if (line == null || !cd.isCommentLine(line)) {
                line = null;
                break;
            }
            Matcher m = versionPattern.matcher(line);
            if (!m.find()) continue;
            line = m.group();
            int start = wordnetStr.length();
            int end = line.length() - copyrightStr.length();
            line = line.substring(start, end);
            break;
        }
        buffer.position(origPos);
        return Version.parseVersion(line);
    }

    public static Version parseVersion(CharSequence verStr) {
        if (verStr == null) {
            return null;
        }
        String[] parts = periodPattern.split(verStr);
        if (parts.length < 2 || parts.length > 3) {
            return null;
        }
        try {
            int bugfix;
            int major = Integer.parseInt(parts[0].trim());
            int minor = Integer.parseInt(parts[1].trim());
            int n = bugfix = parts.length < 3 ? 0 : Integer.parseInt(parts[2].trim());
            if (Version.isIllegalVersionNumber(major, minor, bugfix)) {
                return null;
            }
            return Version.createVersion(major, minor, bugfix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

