/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.process.AbstractListProcessor;
import edu.stanford.nlp.process.StripTagsProcessor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class WordToSentenceProcessor
extends AbstractListProcessor {
    private static final boolean DEBUG = false;
    private Set sentenceBoundaryTokens;
    private Set sentenceBoundaryFollowers;
    private Set sentenceBoundaryToDiscard;
    private Pattern sentenceRegionBeginPattern;
    private Pattern sentenceRegionEndPattern;

    public List process(List words) {
        ArrayList<List> sentences = new ArrayList<List>();
        List currentSentence = null;
        List lastSentence = null;
        boolean insideRegion = false;
        for (Object o : words) {
            String w = null;
            if (o instanceof HasWord) {
                HasWord h = (HasWord)o;
                w = h.word();
            } else if (o instanceof String) {
                w = (String)o;
            } else {
                throw new RuntimeException("Expected token to be either Word or String.");
            }
            if (currentSentence == null) {
                currentSentence = new Sentence();
            }
            if (this.sentenceRegionBeginPattern != null && !insideRegion) {
                if (!this.sentenceRegionBeginPattern.matcher(w).matches()) continue;
                insideRegion = true;
                continue;
            }
            if (this.sentenceBoundaryFollowers.contains(w) && lastSentence != null && currentSentence.size() == 0) {
                lastSentence.add(o);
                continue;
            }
            boolean newSent = false;
            if (this.sentenceBoundaryToDiscard.contains(w)) {
                newSent = true;
            } else if (this.sentenceRegionEndPattern != null && this.sentenceRegionEndPattern.matcher(w).matches()) {
                insideRegion = false;
                newSent = true;
            } else if (this.sentenceBoundaryTokens.contains(w)) {
                currentSentence.add(o);
                newSent = true;
            } else {
                currentSentence.add(o);
            }
            if (!newSent || currentSentence.size() <= 0) continue;
            sentences.add(currentSentence);
            lastSentence = currentSentence;
            currentSentence = null;
        }
        if (currentSentence != null && currentSentence.size() > 0) {
            sentences.add(currentSentence);
        }
        return sentences;
    }

    public WordToSentenceProcessor() {
        this(new HashSet<String>(Arrays.asList(".", "?", "!")));
    }

    public WordToSentenceProcessor(Set boundaryTokens) {
        this(boundaryTokens, new HashSet<String>(Arrays.asList(")", "]", "\"", "'", "''", "-RRB-", "-RSB-")));
    }

    public WordToSentenceProcessor(Set boundaryTokens, Set boundaryFollowers) {
        this(boundaryTokens, boundaryFollowers, Collections.singleton("\n"));
    }

    public WordToSentenceProcessor(Set boundaryTokens, Set boundaryFollowers, Set boundaryToDiscard) {
        this(boundaryTokens, boundaryFollowers, boundaryToDiscard, null, null);
    }

    public WordToSentenceProcessor(Pattern regionBeginPattern, Pattern regionEndPattern) {
        this(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, regionBeginPattern, regionEndPattern);
    }

    private WordToSentenceProcessor(Set boundaryTokens, Set boundaryFollowers, Set boundaryToDiscard, Pattern regionBeginPattern, Pattern regionEndPattern) {
        this.sentenceBoundaryTokens = boundaryTokens;
        this.sentenceBoundaryFollowers = boundaryFollowers;
        this.sentenceBoundaryToDiscard = boundaryToDiscard;
        this.sentenceRegionBeginPattern = regionBeginPattern;
        this.sentenceRegionEndPattern = regionEndPattern;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: java edu.stanford.nlp.process.WordToSentenceProcessor fileOrUrl");
            System.exit(0);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                Document d;
                String filename = args[i];
                if (filename.startsWith("http://")) {
                    BasicDocument dpre = new BasicDocument().init(new URL(filename));
                    StripTagsProcessor notags = new StripTagsProcessor();
                    d = notags.processDocument(dpre);
                } else {
                    d = new BasicDocument().init(new File(filename));
                }
                WordToSentenceProcessor proc = new WordToSentenceProcessor();
                Document sentd = proc.processDocument(d);
                for (Sentence sent : sentd) {
                    System.out.println(sent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

