/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.util;

import java.util.HashMap;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorManager
extends HashMap<String, Color> {
    private static final long serialVersionUID = 1L;
    public static final String COLOR_KEY_White = "WHITE";
    public static final String COLOR_KEY_5PercentGray = "5%GRAY";
    public static final String COLOR_KEY_10PercentGray = "10%GRAY";
    public static final String COLOR_KEY_20PercentGray = "20%GRAY";
    public static final String COLOR_KEY_30PercentGray = "30%GRAY";
    public static final String COLOR_KEY_40PercentGray = "40%GRAY";
    public static final String COLOR_KEY_50PercentGray = "50%GRAY";
    public static final String COLOR_KEY_60PercentGray = "60%GRAY";
    public static final String COLOR_KEY_70PercentGray = "70%GRAY";
    public static final String COLOR_KEY_80PercentGray = "80%GRAY";
    public static final String COLOR_KEY_90PercentGray = "90%GRAY";
    public static final String COLOR_KEY_Black = "BLACK";
    public static final String COLOR_KEY_Red = "RED";
    public static final String COLOR_KEY_Orange = "ORANGE";
    public static final String COLOR_KEY_Yellow = "YELLOW";
    public static final String COLOR_KEY_Green = "GREEN";
    public static final String COLOR_KEY_LightBlue = "LIGHT_BLUE";
    public static final String COLOR_KEY_DarkBlue = "DARK_BLUE";
    public static final String COLOR_KEY_Blue = "BLUE";
    public static final String COLOR_KEY_Indigo = "INDIGO";
    public static final String COLOR_KEY_EclipseRed = "ECLIPSE_RED";
    public static final String COLOR_KEY_EclipseBlue = "ECLIPSE_BLUE";
    public static final HashMap<String, RGB> COLORS = new HashMap();
    Device fDevice;

    static {
        COLORS.put(COLOR_KEY_Black, new RGB(0, 0, 0));
        COLORS.put(COLOR_KEY_90PercentGray, new RGB(26, 26, 26));
        COLORS.put(COLOR_KEY_80PercentGray, new RGB(51, 51, 51));
        COLORS.put(COLOR_KEY_70PercentGray, new RGB(76, 76, 76));
        COLORS.put(COLOR_KEY_60PercentGray, new RGB(102, 102, 102));
        COLORS.put(COLOR_KEY_50PercentGray, new RGB(128, 128, 128));
        COLORS.put(COLOR_KEY_40PercentGray, new RGB(153, 153, 153));
        COLORS.put(COLOR_KEY_30PercentGray, new RGB(179, 179, 179));
        COLORS.put(COLOR_KEY_20PercentGray, new RGB(204, 204, 204));
        COLORS.put(COLOR_KEY_10PercentGray, new RGB(230, 230, 230));
        COLORS.put(COLOR_KEY_5PercentGray, new RGB(243, 243, 243));
        COLORS.put(COLOR_KEY_White, new RGB(255, 255, 255));
        COLORS.put(COLOR_KEY_Red, new RGB(255, 0, 0));
        COLORS.put(COLOR_KEY_Green, new RGB(0, 255, 0));
        COLORS.put(COLOR_KEY_Blue, new RGB(0, 0, 255));
        COLORS.put(COLOR_KEY_Orange, new RGB(255, 128, 0));
        COLORS.put(COLOR_KEY_Yellow, new RGB(255, 255, 0));
        COLORS.put(COLOR_KEY_Indigo, new RGB(255, 0, 255));
        COLORS.put(COLOR_KEY_LightBlue, new RGB(0, 255, 255));
        COLORS.put(COLOR_KEY_EclipseRed, new RGB(200, 25, 42));
        COLORS.put(COLOR_KEY_EclipseBlue, new RGB(0, 63, 255));
        COLORS.put(COLOR_KEY_DarkBlue, new RGB(10, 36, 106));
    }

    public ColorManager(Device device) {
        if (device == null) {
            throw new NullPointerException();
        }
        this.fDevice = device;
    }

    public void put(String key, int red, int green, int blue) {
        this.put(key, new Color(this.fDevice, red, green, blue));
    }

    @Override
    public void put(String key, RGB rgb) {
        this.put(key, new Color(this.fDevice, rgb));
    }

    @Override
    public Color get(Object key) {
        RGB rgbResult;
        Color result = (Color)super.get(key);
        if (result == null && key instanceof String && (rgbResult = COLORS.get(key)) != null) {
            result = new Color(this.fDevice, rgbResult);
            this.put((String)key, result);
        }
        return result;
    }

    public void dispose() {
        for (Color color : this.values()) {
            color.dispose();
        }
    }

    public static void inheritColors(Control control) {
        JFaceColors.setColors((Control)control, (Color)control.getParent().getForeground(), (Color)control.getParent().getBackground());
    }
}

