/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.HasAnnotationController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.controllers.SelectSingleStrategy;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AnnotationModelChild;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescController<M extends IDescModel>
extends HasAnnotationController
implements IDescController<M> {
    protected final M descModel;
    protected final IStoryEditor editor;
    protected final ICaptureStrategy strategy;

    public DescController(M descModel, String annotationID, IStoryEditor editor) {
        this(descModel, annotationID, editor, new SelectSingleStrategy(descModel.getReps(), editor));
    }

    public DescController(M descModel, String annotationID, IStoryEditor editor, ICaptureStrategy strategy) {
        super(annotationID, AnnotationModelChild.createChildAnnotationModel(editor));
        if (editor == null) {
            throw new NullPointerException();
        }
        if (descModel == null) {
            throw new NullPointerException();
        }
        if (strategy == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.strategy = strategy;
        this.descModel = descModel;
        this.descModel.addChangeListener((ChangeListener)this);
    }

    @Override
    public M getDescModel() {
        return this.descModel;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public void next() {
        IDesc current = this.descModel.getDesc();
        if (current == null) {
            for (IRep rep : this.descModel.getReps()) {
                IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
                if (descs.isEmpty()) continue;
                this.setDesc((IDesc)descs.first());
                break;
            }
        } else {
            IRep target = current.getRep();
            boolean foundTarget = false;
            for (IRep rep : this.descModel.getReps()) {
                if (rep == target) {
                    foundTarget = true;
                }
                if (!foundTarget) continue;
                IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
                if (rep == target) {
                    descs = descs.tailSet(current);
                    Iterator i = descs.iterator();
                    i.next();
                    if (!i.hasNext()) continue;
                    this.setDesc((IDesc)i.next());
                    continue;
                }
                if (descs.isEmpty()) continue;
                this.setDesc((IDesc)descs.first());
                break;
            }
        }
        this.updateAnnotations();
    }

    @Override
    public void previous() {
        TreeSet reps = new TreeSet(Collections.reverseOrder());
        reps.addAll(this.descModel.getReps());
        IDesc current = this.descModel.getDesc();
        if (current == null) {
            for (IRep rep : reps) {
                IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
                if (descs.isEmpty()) continue;
                this.setDesc((IDesc)descs.last());
                break;
            }
        } else {
            IRep target = current.getRep();
            boolean foundTarget = false;
            for (IRep rep : reps) {
                if (rep == target) {
                    foundTarget = true;
                }
                if (!foundTarget) continue;
                IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
                if (rep == target) {
                    if ((descs = descs.headSet(current)).isEmpty()) continue;
                    this.setDesc((IDesc)descs.last());
                    continue;
                }
                if (descs.isEmpty()) continue;
                this.setDesc((IDesc)descs.first());
                break;
            }
        }
        this.updateAnnotations();
    }

    @Override
    public void capture() {
        IDesc desc = this.strategy.capture();
        if (desc != null) {
            this.setDesc(desc);
        }
        this.updateAnnotations();
    }

    protected void setDesc(IDesc desc) {
        this.descModel.setDesc(desc);
    }

    @Override
    public void clear() {
        this.descModel.clear();
        this.getAnnotationController().clear();
    }

    @Override
    protected IHasPositionSet<? extends IHasPosition> getPositions() {
        IDesc desc = this.descModel.getDesc();
        return desc == null ? new HasPositionSet() : new HasPositionSet(Collections.singleton(desc));
    }

    public void dispose() {
        this.descModel.removeChangeListener((ChangeListener)this);
        this.descModel.dispose();
    }
}

