/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.editor;

import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.rep.character.changes.SetEditableChange;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.ui.IPropertyListener;

public class AllowEditingAction
extends ResourceAction2
implements IHasStoryEditor,
IPropertyListener {
    IStoryEditor editor;

    public AllowEditingAction(IStoryEditor editor) {
        super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_AllowTextEditing_prefix, 2);
        this.setStoryEditor(editor);
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        this.editor = newEditor;
        if (this.editor != null) {
            this.editor.addPropertyListener(this);
        }
        this.updateState();
    }

    public void updateState() {
        if (this.editor != null) {
            this.setChecked(this.editor.isEditable());
        }
    }

    public void run() {
        IStoryEditor editor = this.getStoryEditor();
        if (editor == null) {
            return;
        }
        boolean editable = this.isChecked();
        editor.getStoryModel().applyChange((Object)this, (IModelChange)new SetEditableChange(editable), false);
    }

    public void propertyChanged(Object source, int propId) {
        if (source != this.editor || propId != IStoryEditor.PROP_EDITABLE) {
            return;
        }
        this.updateState();
    }
}

