/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class TextTransfer
extends ByteArrayTransfer {
    static TextTransfer _instance = new TextTransfer();
    static final String TEXT = "TEXT";
    static final String UTEXT = "utxt";
    static final String UTF8 = "utf8";
    static final int TEXTID = 0x54455854;
    static final int UTEXTID = 1970567284;
    static final int UTF8ID = 1970562616;

    TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        transferData.result = -1;
        switch (transferData.type) {
            case 0x54455854: 
            case 1970562616: {
                int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (cfstring == 0) {
                    return;
                }
                byte[] buffer = null;
                try {
                    CFRange range = new CFRange();
                    range.length = chars.length;
                    int encoding = transferData.type == 1970562616 ? 0x8000100 : OS.CFStringGetSystemEncoding();
                    int[] size = new int[1];
                    int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
                    if (numChars == 0) {
                        return;
                    }
                    buffer = new byte[size[0]];
                    numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
                    if (numChars == 0) {
                        return;
                    }
                }
                finally {
                    OS.CFRelease(cfstring);
                }
                transferData.data = new byte[1][];
                transferData.data[0] = buffer;
                transferData.result = 0;
                return;
            }
            case 1970567284: {
                byte[] buffer = new byte[chars.length * 2];
                OS.memmove(buffer, chars, buffer.length);
                transferData.data = new byte[1][];
                transferData.data[0] = buffer;
                transferData.result = 0;
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        byte[] buffer = transferData.data[0];
        switch (transferData.type) {
            case 0x54455854: 
            case 1970562616: {
                int encoding = transferData.type == 1970562616 ? 0x8000100 : OS.CFStringGetSystemEncoding();
                int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, true);
                if (cfstring == 0) {
                    return null;
                }
                try {
                    int length = OS.CFStringGetLength(cfstring);
                    if (length == 0) {
                        return null;
                    }
                    char[] chars = new char[length];
                    CFRange range = new CFRange();
                    range.length = length;
                    OS.CFStringGetCharacters(cfstring, range, chars);
                    String string = new String(chars);
                    return string;
                }
                finally {
                    OS.CFRelease(cfstring);
                }
            }
            case 1970567284: {
                char[] chars = new char[(buffer.length + 1) / 2];
                OS.memmove(chars, buffer, buffer.length);
                return new String(chars);
            }
        }
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{1970567284, 1970562616, 0x54455854};
    }

    protected String[] getTypeNames() {
        return new String[]{UTEXT, UTF8, TEXT};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

