/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep;

import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepComparator;
import edu.mit.story.core.util.ImmutableIterator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepSet
extends AbstractSet<IRep>
implements IRepSet {
    private static final long serialVersionUID = -3670418653843831291L;
    final RepSet parent;
    final SortedSet<IRep> backing;
    final IRep fromRep;
    final IRep toRep;

    public RepSet() {
        this.backing = this.createBackingSet(null);
        this.fromRep = null;
        this.toRep = null;
        this.parent = null;
    }

    public RepSet(IRep ... reps) {
        this(Arrays.asList(reps));
    }

    public RepSet(Collection<? extends IRep> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.backing = this.createBackingSet(c);
        this.fromRep = null;
        this.toRep = null;
        this.parent = null;
    }

    protected RepSet(RepSet parent, SortedSet<IRep> backing, IRep fromRep, IRep toRep) {
        this.parent = parent;
        this.fromRep = fromRep;
        this.toRep = toRep;
        this.backing = backing;
    }

    protected SortedSet<IRep> createBackingSet(Collection<? extends IRep> c) {
        TreeSet<IRep> result = new TreeSet<IRep>(RepComparator.getInstance());
        if (c != null) {
            result.addAll(c);
        }
        return result;
    }

    protected RepSet getSubsetParent() {
        return this.parent == null ? this : this.parent;
    }

    protected void elementAdded(IRep r) {
    }

    protected void elementRemoved(IRep r) {
    }

    @Override
    public boolean add(IRep o) {
        if (!this.backing.add(o)) {
            return false;
        }
        this.elementAdded(o);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.backing.remove(o)) {
            return false;
        }
        this.elementRemoved((IRep)o);
        return true;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public Iterator<IRep> iterator() {
        return new RepresentationSetIterator();
    }

    @Override
    public IRepSet subSet(IRep fromElement, IRep toElement) {
        return this.createSubset(this.getSubsetParent(), this.backing.subSet(fromElement, toElement), fromElement, toElement);
    }

    @Override
    public IRepSet headSet(IRep toElement) {
        if (this.fromRep != null) {
            return this.createSubset(this.getSubsetParent(), this.backing.subSet(this.fromRep, toElement), this.fromRep, toElement);
        }
        return this.createSubset(this.getSubsetParent(), this.backing.headSet(toElement), null, toElement);
    }

    @Override
    public IRepSet tailSet(IRep fromElement) {
        if (this.toRep != null) {
            return this.createSubset(this.getSubsetParent(), this.backing.subSet(fromElement, this.toRep), fromElement, this.toRep);
        }
        return this.createSubset(this.getSubsetParent(), this.backing.tailSet(fromElement), fromElement, null);
    }

    protected RepSet createSubset(RepSet parent, SortedSet<IRep> backing, IRep fromRep, IRep toRep) {
        return new RepSet(parent, backing, fromRep, toRep);
    }

    @Override
    public Comparator<? super IRep> comparator() {
        return this.backing.comparator();
    }

    @Override
    public IRep first() {
        return this.backing.first();
    }

    @Override
    public IRep last() {
        return this.backing.last();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public boolean supports(IRep rep) {
        return this.contains(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.containsAll(reps);
    }

    @Override
    public Iterator<IRep> repIterator() {
        return this.iterator();
    }

    @Override
    public int repSize() {
        return this.size();
    }

    @Override
    public IRepSet getSupported() {
        return new RepSet(this);
    }

    @Override
    public boolean addSupport(IRep rep) {
        return this.add(rep);
    }

    @Override
    public boolean addAllSupport(Collection<? extends IRep> reps) {
        IRepSet toAdd = reps instanceof IRepSet ? (IRepSet)reps : new RepSet(reps);
        boolean changed = false;
        for (IRep rep : toAdd) {
            changed |= this.addSupport(rep);
        }
        return changed;
    }

    @Override
    public boolean removeSupport(IRep rep) {
        return this.remove(rep);
    }

    @Override
    public boolean removeAllSupport(Collection<? extends IRep> reps) {
        TreeSet<IRep> toRemove = new TreeSet<IRep>(RepComparator.getReverseInstance());
        toRemove.addAll(reps);
        boolean changed = false;
        for (IRep rep : toRemove) {
            changed |= this.removeSupport(rep);
        }
        return changed;
    }

    @Override
    public final int getImplementationCode() {
        return 2;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IRepresentationSet;
    }

    @Override
    public final String getSerializedData() {
        return null;
    }

    public static IRepSet unmodifiableSet(IRepSet set) {
        return new UnmodifiableRepSet(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepresentationSetIterator
    implements Iterator<IRep> {
        Iterator<IRep> backingItr;
        IRep last;

        protected RepresentationSetIterator() {
            this.backingItr = RepSet.this.backing.iterator();
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.backingItr.hasNext();
        }

        @Override
        public IRep next() {
            this.last = this.backingItr.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.backingItr.remove();
            RepSet.this.elementRemoved(this.last);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnmodifiableRepSet
    implements IRepSet {
        private static final long serialVersionUID = 1L;
        private final IRepSet backingSet;

        public UnmodifiableRepSet(IRepSet backingSet) {
            if (backingSet == null) {
                throw new NullPointerException();
            }
            this.backingSet = backingSet;
        }

        @Override
        public IRepSet headSet(IRep toElement) {
            return new UnmodifiableRepSet(this.backingSet.headSet(toElement));
        }

        @Override
        public IRepSet subSet(IRep fromElement, IRep toElement) {
            return new UnmodifiableRepSet(this.backingSet.subSet(fromElement, toElement));
        }

        @Override
        public IRepSet tailSet(IRep fromElement) {
            return new UnmodifiableRepSet(this.backingSet.tailSet(fromElement));
        }

        @Override
        public Comparator<? super IRep> comparator() {
            return this.backingSet.comparator();
        }

        @Override
        public IRep first() {
            return (IRep)this.backingSet.first();
        }

        @Override
        public IRep last() {
            return (IRep)this.backingSet.first();
        }

        @Override
        public boolean add(IRep o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends IRep> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingSet.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.backingSet.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.backingSet.isEmpty();
        }

        @Override
        public Iterator<IRep> iterator() {
            return new ImmutableIterator<IRep>(this.backingSet.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public Object[] toArray() {
            return this.backingSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.backingSet.toArray(a);
        }

        @Override
        public int getImplementationCode() {
            return this.backingSet.getImplementationCode();
        }

        @Override
        public String getImplementationName() {
            return this.backingSet.getImplementationName();
        }

        @Override
        public String getSerializedData() {
            return this.backingSet.getSerializedData();
        }

        public Object getAdapter(Class adapter) {
            return this.backingSet.getAdapter(adapter);
        }

        @Override
        public boolean addAllSupport(Collection<? extends IRep> reps) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addSupport(IRep rep) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllSupport(Collection<? extends IRep> reps) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeSupport(IRep rep) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRepSet getSupported() {
            return this.backingSet.getSupported();
        }

        @Override
        public Iterator<IRep> repIterator() {
            return new ImmutableIterator<IRep>(this.backingSet.repIterator());
        }

        @Override
        public int repSize() {
            return this.backingSet.repSize();
        }

        @Override
        public boolean supports(IRep rep) {
            return this.backingSet.supports(rep);
        }

        @Override
        public boolean supportsAll(Collection<? extends IRep> reps) {
            return this.backingSet.supportsAll(reps);
        }
    }
}

