/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.core.util.Immutable;
import edu.mit.story.core.validation.BaseValidator;
import edu.mit.story.core.validation.IValidator;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptor
extends BaseValidator<String>
implements IPropertyDescriptor,
Immutable {
    private final String id;
    private final String name;
    private final String description;
    private final String defaultValue;
    private final boolean isConfigurable;
    private final IValidator<String> validator;

    public PropertyDescriptor(String id, String name, String description, String defaultValue, IValidator<String> validator, boolean isConfigurable) {
        IMessageProvider message;
        if (id.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (validator != null && !validator.allowsInitialInvalidValue() && (message = validator.validate(defaultValue)) != null && message.getMessageType() == 3) {
            throw new IllegalArgumentException(message.getMessage());
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validator = validator;
        this.isConfigurable = isConfigurable;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public IValidator<String> getValidator() {
        return this.validator;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        return super.isValid(value);
    }

    @Override
    public IMessageProvider validate(String value) {
        return this.validator == null ? null : this.validator.validate(value);
    }

    @Override
    public boolean isConfigurableProperty() {
        return this.isConfigurable;
    }
}

