/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.StoryData;
import edu.mit.story.core.model.change.CascadingModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IModelConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepComparator;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.UnsupportedRepException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryModel
implements IMutableStoryModel {
    private static final long serialVersionUID = 5687171039461137988L;
    protected final IStoryData descs;
    protected final Map<IRep, IDescFactory> factories = new TreeMap<IRep, IDescFactory>();
    protected final ListenerList listeners = new ListenerList();
    private final Object initSync = new Object();
    private boolean isInitialized = false;
    private final IRep fPrimary;
    private long nextID = 1L;
    private String corpus;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public StoryModel(IRep primary) {
        this(primary, (String)null);
    }

    public StoryModel(IRep primary, String corpus) {
        if (primary == null) {
            throw new NullPointerException();
        }
        this.fPrimary = primary;
        this.descs = new StoryData();
        this.descs.addSupport(this.fPrimary);
        this.corpus = corpus;
    }

    public StoryModel(IRep primary, IModelConfiguration modelConfig) {
        this(primary, modelConfig.getCorpus());
        this.descs.addAllSupport(RepUtils.closeWithAntecedents(modelConfig.getSupported()));
        IFactoryManager fm = StoryPlugin.getDefault().getFactoryManager();
        Iterator<IRep> i = modelConfig.repIterator();
        while (i.hasNext()) {
            IRep rep = i.next();
            IConfiguration config = modelConfig.getRepConfiguration(rep);
            if (config != null) {
                this.descs.setConfiguration(config.clone());
            }
            String id = modelConfig.getFactoryID(rep);
            config = modelConfig.getFactoryConfiguration(rep);
            IFactoryDescriptor desc = (IFactoryDescriptor)fm.getDescriptor(id);
            if (desc == null) continue;
            IDescFactory factory = (IDescFactory)desc.create(config);
            this.setFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = this.initSync;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
            boolean success = true;
            for (IDescFactory factory : this.factories.values()) {
                factory.init(this);
                if (factory.isInitialized()) continue;
                success = false;
            }
            this.isInitialized = success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = this.initSync;
        synchronized (object) {
            return this.isInitialized;
        }
    }

    @Override
    public void dispose() {
        TreeSet<IRep> reps = new TreeSet<IRep>(RepComparator.getReverseInstance());
        reps.addAll(this.factories.keySet());
        for (IRep rep : reps) {
            IDescFactory fact = this.factories.get(rep);
            if (fact == null) continue;
            fact.dispose(this);
        }
    }

    @Override
    public IRep getPrimary() {
        return this.fPrimary;
    }

    @Override
    public long getNextID() {
        return this.nextID++;
    }

    protected void incrementPastID(long id) {
        this.nextID = Math.max(this.nextID, id);
        if (this.nextID == id) {
            ++this.nextID;
        }
    }

    protected void setNextID(long newNextID) {
        this.nextID = newNextID;
    }

    @Override
    public IDescFactory getFactory(IRep rep) {
        if (!this.supports(rep)) {
            throw new UnsupportedRepException(rep);
        }
        return this.factories.get(rep);
    }

    @Override
    public IDescFactory setFactory(IDescFactory factory) {
        if (!this.supports(factory.getRep())) {
            throw new UnsupportedRepException(factory.getRep());
        }
        if (this.isInitialized()) {
            factory.init(this);
        }
        return this.factories.put(factory.getRep(), factory);
    }

    @Override
    public IDescFactory removeFactory(IRep rep) {
        if (!this.supports(rep)) {
            throw new UnsupportedRepException(rep);
        }
        IDescFactory result = this.factories.remove(rep);
        result.dispose(this);
        return result;
    }

    @Override
    public ListenerList getProviderChangeListeners() {
        return this.listeners;
    }

    @Override
    public void addModelListener(IModelListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeModelListener(IModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public IStoryData getData() {
        return this.descs;
    }

    @Override
    public boolean supports(IRep rep) {
        return this.descs.supports(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> rs) {
        return this.descs.supportsAll(rs);
    }

    @Override
    public Iterator<IRep> repIterator() {
        return this.descs.repIterator();
    }

    @Override
    public int repSize() {
        return this.descs.repSize();
    }

    @Override
    public IRepSet getSupported() {
        return this.descs.getSupported();
    }

    @Override
    public StoryChangeEvent applyChange(Object source, IModelChange change, boolean block) {
        change = change instanceof CascadingModelChange ? change : new CascadingModelChange(change);
        return change.apply(source, this);
    }

    @Override
    public final int getImplementationCode() {
        return 8;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IDescriptionProvider;
    }

    @Override
    public final String getSerializedData() {
        return this.descs.getSerializedData();
    }

    @Override
    public int getLength() {
        return this.fPrimary.getIndexLength(this.descs);
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getRightOffset() {
        return this.fPrimary.getIndexLength(this.descs);
    }

    @Override
    public String getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(String name) {
        this.corpus = name;
    }
}

