/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.content;

import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;

public class Timex3ContentProvider
extends StoryEditorContentProvider {
    public static final int CHILD_TYPE_QUANTIFIER = 1;
    public static final int CHILD_TYPE_FREQUENCY = 2;

    public Timex3ContentProvider(IStoryEditor editor) {
        super(Timex3Rep.getInstance(), editor, "(no time expressions)");
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IDesc) {
            element = ((IDesc)element).getData();
        }
        if (element instanceof ITimex3) {
            ITimex3 timex = (ITimex3)element;
            if (timex.getModifier() != ITimex3.Mod.NONE) {
                return true;
            }
            if (timex.getFunction() != ITimex3.Function.NONE) {
                return true;
            }
            if (timex.getQuantifier() != null) {
                return true;
            }
            if (timex.getFrequency() != null) {
                return true;
            }
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        Object[] defaultChildren = super.getChildren(element);
        Object parent = element;
        if (parent instanceof IDesc) {
            IDesc desc = (IDesc)parent;
            parent = (ITimex3)desc.getData();
        }
        if (parent instanceof ITimex3) {
            ITimex3 timex = (ITimex3)parent;
            ArrayList<Object> children = new ArrayList<Object>(4);
            if (timex.getModifier() != ITimex3.Mod.NONE) {
                children.add(Timex3ContentProvider.makeChild((Object)element, (Object)timex.getModifier()));
            }
            if (timex.getFunction() != ITimex3.Function.NONE) {
                children.add(Timex3ContentProvider.makeChild((Object)element, (Object)timex.getFunction()));
            }
            if (timex.getQuantifier() != null) {
                children.add(Timex3ContentProvider.makeChild((int)1, (Object)element, (Object)timex.getQuantifier()));
            }
            if (timex.getFrequency() != null) {
                children.add(Timex3ContentProvider.makeChild((int)2, (Object)element, (Object)timex.getFrequency()));
            }
            if (defaultChildren != null) {
                Object[] objectArray = defaultChildren;
                int n = defaultChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    children.add(child);
                    ++n2;
                }
            }
            return children.toArray();
        }
        return defaultChildren;
    }

    public Object[] getElements(Object input) {
        if (input instanceof IDesc) {
            IDesc desc = (IDesc)input;
            return new Object[]{desc.getData()};
        }
        return super.getElements(input);
    }
}

